/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.address;

import java.util.ArrayList;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.address.route.flowcontrol.random.RandomFlowControl;
import net.hasor.rsf.address.route.flowcontrol.speed.SpeedFlowControl;
import net.hasor.rsf.address.route.flowcontrol.unit.UnitFlowControl;
import net.hasor.rsf.address.route.rule.Rule;
import net.hasor.rsf.address.route.rule.RuleParser;
import net.hasor.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowControlRef {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static RuleParser ruleParser;
    public String flowControlScript = null;
    public UnitFlowControl unitFlowControl = null;
    public RandomFlowControl randomFlowControl = null;
    public SpeedFlowControl speedFlowControl = null;

    private FlowControlRef(RsfEnvironment rsfEnvironment) {
        if (ruleParser == null) {
            ruleParser = new RuleParser(rsfEnvironment);
        }
    }

    public void updateFlowControl(String flowControl) {
        if (StringUtils.isBlank((String)flowControl)) {
            this.logger.error("flowControl body is null.");
            return;
        }
        if (!(flowControl = flowControl.trim()).startsWith("<controlSet") || !flowControl.endsWith("</controlSet>")) {
            this.logger.error("flowControl body format error.");
            return;
        }
        this.flowControlScript = flowControl;
        ArrayList<String> ruleBodyList = new ArrayList<String>();
        String tagNameBegin = "<flowControl";
        String tagNameEnd = "</flowControl>";
        int beginIndex = 0;
        int endIndex = 0;
        while (true) {
            beginIndex = flowControl.indexOf("<flowControl", endIndex);
            endIndex = flowControl.indexOf("</flowControl>", endIndex + "</flowControl>".length());
            if (beginIndex < 0 || endIndex < 0) break;
            String flowControlBody = flowControl.substring(beginIndex, endIndex + "</flowControl>".length());
            ruleBodyList.add(flowControlBody);
        }
        if (ruleBodyList.isEmpty()) {
            this.logger.warn("flowControl is empty.");
            return;
        }
        for (int i = 0; i < ruleBodyList.size(); ++i) {
            String controlBody = (String)ruleBodyList.get(i);
            Rule rule = ruleParser.ruleSettings(controlBody);
            if (rule == null) continue;
            String simpleName = rule.getClass().getSimpleName();
            this.logger.info("setup flowControl type is {}.", (Object)simpleName);
            if (rule instanceof UnitFlowControl) {
                this.unitFlowControl = (UnitFlowControl)rule;
                continue;
            }
            if (rule instanceof RandomFlowControl) {
                this.randomFlowControl = (RandomFlowControl)rule;
                continue;
            }
            if (!(rule instanceof SpeedFlowControl)) continue;
            this.speedFlowControl = (SpeedFlowControl)rule;
        }
    }

    public static final FlowControlRef newRef(RsfEnvironment rsfEnvironment, FlowControlRef ref) {
        FlowControlRef newRef = FlowControlRef.defaultRef(rsfEnvironment);
        if (!StringUtils.isBlank((String)ref.flowControlScript)) {
            newRef.flowControlScript = ref.flowControlScript;
        }
        if (ref.unitFlowControl != null) {
            newRef.unitFlowControl = ref.unitFlowControl;
        }
        if (ref.randomFlowControl != null) {
            newRef.randomFlowControl = ref.randomFlowControl;
        }
        if (ref.speedFlowControl != null) {
            newRef.speedFlowControl = ref.speedFlowControl;
        }
        return newRef;
    }

    public static final FlowControlRef defaultRef(RsfEnvironment rsfEnvironment) {
        FlowControlRef flowControlRef = new FlowControlRef(rsfEnvironment);
        flowControlRef.randomFlowControl = new RandomFlowControl();
        flowControlRef.speedFlowControl = SpeedFlowControl.defaultControl(rsfEnvironment);
        return flowControlRef;
    }
}

