/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.address;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.RsfSettings;
import net.hasor.rsf.address.AddressPool;
import net.hasor.rsf.utils.IOUtils;
import net.hasor.utils.MatchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskCacheAddressPool
extends AddressPool {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private final Thread timer;
    private final File snapshotHome;
    private final File indexFile;
    private boolean exitThread = false;

    public DiskCacheAddressPool(final RsfEnvironment rsfEnvironment) {
        super(rsfEnvironment);
        File rsfHome = new File(rsfEnvironment.evalString("%RSF_DATA_HOME%/"));
        this.snapshotHome = new File(rsfHome, "/snapshot");
        this.indexFile = new File(this.snapshotHome, "address.index");
        this.timer = new Thread(new Runnable(){

            @Override
            public void run() {
                if (rsfEnvironment.getSettings().islocalDiskCache()) {
                    DiskCacheAddressPool.this.doWork();
                }
            }
        });
        this.timer.setContextClassLoader(rsfEnvironment.getClassLoader());
        this.timer.setName("RSF-DiskCacheAddressPool-Timer");
        this.timer.setDaemon(true);
    }

    public void startTimer() {
        if (this.inited.compareAndSet(false, true)) {
            this.logger.info("startTimer address snapshot Thread[{}].", (Object)this.timer.getName());
            this.exitThread = false;
            this.timer.start();
        }
    }

    public void shutdownTimer() {
        if (this.inited.compareAndSet(true, false)) {
            this.logger.info("shutdownTimer address snapshot Thread[{}].", (Object)this.timer.getName());
            this.exitThread = true;
        }
    }

    private void doWork() {
        this.exitThread = false;
        RsfSettings rsfSettings = this.getRsfEnvironment().getSettings();
        long refreshCacheTime = rsfSettings.getRefreshCacheTime();
        long diskCacheTimeInterval = rsfSettings.getDiskCacheTimeInterval();
        long nextCheckSavePoint = 0L;
        if (diskCacheTimeInterval <= 0L) {
            diskCacheTimeInterval = 3600000L;
        }
        this.logger.info("AddressPool - Timer -> start, refreshCacheTime = {}.", (Object)refreshCacheTime);
        while (!this.exitThread) {
            this.clearCacheData();
            try {
                Thread.sleep(refreshCacheTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.logger.info("AddressPool - refreshCache. at = {} , refreshCacheTime = {}.", (Object)DiskCacheAddressPool.nowTime(), (Object)refreshCacheTime);
            this.refreshAddressCache();
            if (!rsfSettings.islocalDiskCache() || nextCheckSavePoint >= System.currentTimeMillis()) continue;
            nextCheckSavePoint = System.currentTimeMillis() + diskCacheTimeInterval;
            try {
                this.storeConfig();
            }
            catch (IOException e) {
                this.logger.error("saveAddress error {} -> {}", (Object)e.getMessage(), (Object)e);
            }
        }
        this.logger.info("AddressPool - Timer -> stop.");
    }

    public void clearCacheData() {
        String[] fileNames = this.snapshotHome.list((dir, name) -> MatchUtils.wildToRegex((String)"address-[0-9]{8}-[0-9]{6}.zip", (String)name, (MatchUtils.MatchTypeEnum)MatchUtils.MatchTypeEnum.Regex));
        List<Object> sortList = fileNames == null ? new ArrayList(0) : Arrays.asList(fileNames);
        Collections.sort(sortList);
        long nowTime = System.currentTimeMillis() - 604800000L;
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd-HHmmss");
        for (String string : sortList) {
            try {
                String dateTimeStr = string.substring("addr-pool-".length(), string.length() - ".zip".length());
                Date dateTime = format.parse(dateTimeStr);
                if (dateTime.getTime() >= nowTime) continue;
                new File(this.snapshotHome, string).delete();
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void storeConfig() throws IOException {
        File writeFile = null;
        while (writeFile == null || writeFile.exists()) {
            writeFile = new File(this.snapshotHome, "addr-pool-" + DiskCacheAddressPool.nowTime() + ".zip");
        }
        this.logger.info("rsf - saveAddress to snapshot file({}) ->{}", (Object)writeFile);
        FileOutputStream fos = null;
        OutputStreamWriter fw = null;
        try {
            boolean mkdirResult = writeFile.getParentFile().mkdirs();
            if (mkdirResult || writeFile.getParentFile().exists()) {
                fos = new FileOutputStream(writeFile, false);
                fos.getFD().sync();
                this.storeConfig(fos);
                fos.flush();
                fos.close();
                fw = new FileWriter(this.indexFile, false);
                this.logger.info("rsf - update snapshot index -> " + this.indexFile.getAbsolutePath());
                fw.write(writeFile.getName());
                fw.flush();
                fw.close();
            }
        }
        catch (IOException e) {
            this.logger.error("rsf - saveAddress " + e.getClass().getSimpleName() + " :" + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (fw != null) {
                fw.close();
            }
        }
    }

    public synchronized void restoreConfig() {
        block9: {
            if (!this.indexFile.exists()) {
                this.logger.info("address snapshot index file, undefined.");
                return;
            }
            if (!this.indexFile.canRead()) {
                this.logger.error("address snapshot index file, can not read.");
                return;
            }
            File readFile = null;
            try {
                FileReader reader = new FileReader(this.indexFile);
                List bodyList = IOUtils.readLines((Reader)reader);
                String index = bodyList.isEmpty() ? "" : (String)bodyList.get(0);
                readFile = new File(this.snapshotHome, index);
                if ("".equals(index) || !readFile.exists()) {
                    this.logger.error("address snapshot file is not exist.", (Object)readFile);
                    return;
                }
            }
            catch (Throwable e) {
                this.logger.error("read the snapshot file name error :" + e.getMessage(), e);
                return;
            }
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(readFile);
                this.restoreConfig(inStream);
                inStream.close();
            }
            catch (IOException e) {
                this.logger.error("read the snapshot file name error :" + e.getMessage(), (Throwable)e);
                if (inStream == null) break block9;
                try {
                    inStream.close();
                }
                catch (IOException e1) {
                    this.logger.error(e1.getMessage(), (Throwable)e1);
                }
            }
        }
    }

    private static String nowTime() {
        return new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
    }
}

