/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.address;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.RsfEnvironment;
import net.hasor.rsf.RsfSettings;
import net.hasor.rsf.RsfUpdater;
import net.hasor.rsf.address.AddressBucket;
import net.hasor.rsf.address.AddressCacheResult;
import net.hasor.rsf.address.AddressTypeEnum;
import net.hasor.rsf.address.FlowControlRef;
import net.hasor.rsf.address.RouteTypeEnum;
import net.hasor.rsf.address.RuleRef;
import net.hasor.rsf.address.route.rule.ArgsKey;
import net.hasor.rsf.address.route.rule.DefaultArgsKey;
import net.hasor.utils.ClassUtils;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.StringUtils;
import net.hasor.utils.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressPool
implements RsfUpdater {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RsfEnvironment rsfEnvironment;
    private final ConcurrentMap<String, AddressBucket> addressPool;
    private final String unitName;
    private final AddressCacheResult rulerCache;
    private final ArgsKey argsKey;
    private final Object poolLock;

    public AddressPool(RsfEnvironment rsfEnvironment) {
        String unitName = rsfEnvironment.getSettings().getUnitName();
        this.logger.info("AddressPool unitName at {}", (Object)unitName);
        this.rsfEnvironment = rsfEnvironment;
        RsfSettings rsfSettings = rsfEnvironment.getSettings();
        this.addressPool = new ConcurrentHashMap<String, AddressBucket>();
        this.unitName = unitName;
        this.rulerCache = new AddressCacheResult(this);
        this.poolLock = new Object();
        String argsKeyType = rsfSettings.getString("hasor.rsfConfig.route.argsKey", DefaultArgsKey.class.getName());
        this.logger.info("argsKey type is {}", (Object)argsKeyType);
        try {
            Class<?> type = Class.forName(argsKeyType, false, ClassUtils.getClassLoader((ClassLoader)rsfEnvironment.getClassLoader()));
            this.argsKey = (ArgsKey)type.newInstance();
        }
        catch (Throwable e) {
            this.logger.error("create argsKey " + argsKeyType + " , message = " + e.getMessage(), e);
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
        rsfEnvironment.getEventContext().addListener("RsfEvent_DeleteService", (event, eventData) -> {
            if (eventData == null) {
                return;
            }
            this.removeBucket(eventData.getBindID());
        });
    }

    public AddressBucket getBucket(String serviceID) {
        return this.addressPool.getOrDefault(serviceID, null);
    }

    public String getUnitName() {
        return this.unitName;
    }

    public RsfEnvironment getRsfEnvironment() {
        return this.rsfEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<InterAddress>> allServiceAddressToSnapshot() {
        HashMap<String, List<InterAddress>> snapshot = new HashMap<String, List<InterAddress>>();
        Object object = this.poolLock;
        synchronized (object) {
            for (String key : this.addressPool.keySet()) {
                AddressBucket bucket = (AddressBucket)this.addressPool.get(key);
                snapshot.put(key + "_ALL", bucket.getAllAddresses());
                snapshot.put(key + "_UNIT", bucket.getLocalUnitAddresses());
                snapshot.put(key + "_INVALID", bucket.getInvalidAddresses());
                snapshot.put(key, bucket.getAvailableAddresses());
            }
        }
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getBucketNames() {
        HashSet<String> duplicate = new HashSet<String>();
        Object object = this.poolLock;
        synchronized (object) {
            duplicate.addAll(this.addressPool.keySet());
        }
        return duplicate;
    }

    public void appendStaticAddress(String serviceID, InterAddress newHost) {
        List<InterAddress> newHostSet = Collections.singletonList(newHost);
        this.appendStaticAddress(serviceID, newHostSet);
    }

    @Override
    public void appendStaticAddress(String serviceID, Collection<InterAddress> newHostSet) {
        this._appendAddress(serviceID, newHostSet, AddressTypeEnum.Static);
    }

    public void appendAddress(String serviceID, InterAddress newHost) {
        List<InterAddress> newHostSet = Collections.singletonList(newHost);
        this.appendAddress(serviceID, newHostSet);
    }

    @Override
    public void appendAddress(String serviceID, Collection<InterAddress> newHostSet) {
        this._appendAddress(serviceID, newHostSet, AddressTypeEnum.Dynamic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _appendAddress(String serviceID, Collection<InterAddress> newHostSet, AddressTypeEnum type) {
        String hosts = StringUtils.join((Object[])newHostSet.toArray(), (String)", ");
        this.logger.info("updateAddress of service {} , new Address set = {} ", (Object)serviceID, (Object)hosts);
        AddressBucket bucket = (AddressBucket)this.addressPool.get(serviceID);
        if (bucket == null) {
            Object object = this.poolLock;
            synchronized (object) {
                AddressBucket newBucket = new AddressBucket(serviceID, this.rsfEnvironment);
                bucket = this.addressPool.putIfAbsent(serviceID, newBucket);
                if (bucket == null) {
                    bucket = newBucket;
                }
                this.logger.info("newBucket {}", (Object)bucket);
            }
        }
        bucket.newAddress(newHostSet, type);
        bucket.refreshAddress();
        this.rulerCache.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidAddress(InterAddress address) {
        long invalidWaitTime = this.rsfEnvironment.getSettings().getInvalidWaitTime();
        Object object = this.poolLock;
        synchronized (object) {
            Set keySet = this.addressPool.keySet();
            for (String bucketKey : keySet) {
                this.logger.info("serviceID ={} ,invalid address = {} ,bucket is not exist.", (Object)bucketKey, (Object)address);
                AddressBucket bucket = (AddressBucket)this.addressPool.get(bucketKey);
                bucket.invalidAddress(address, invalidWaitTime);
                bucket.refreshAddress();
            }
            this.rulerCache.reset();
        }
        this.rulerCache.reset();
    }

    @Override
    public void removeAddress(String serviceID, InterAddress invalidAddress) {
        this.removeAddress(serviceID, Collections.singletonList(invalidAddress));
    }

    @Override
    public void removeAddress(String serviceID, Collection<InterAddress> invalidAddressSet) {
        AddressBucket bucket = (AddressBucket)this.addressPool.get(serviceID);
        if (bucket == null) {
            this.logger.info("serviceID ={} ,bucket is not exist.", (Object)serviceID);
            return;
        }
        StringBuilder strBuilder = new StringBuilder("");
        if (invalidAddressSet == null || invalidAddressSet.isEmpty()) {
            strBuilder.append("empty.");
        } else {
            for (InterAddress invalidAddress : invalidAddressSet) {
                strBuilder.append(invalidAddress.toHostSchema() + ",");
                bucket.removeAddress(invalidAddress);
                bucket.refreshAddress();
                this.rulerCache.reset();
            }
        }
        long invalidWaitTime = this.rsfEnvironment.getSettings().getInvalidWaitTime();
        this.logger.info("serviceID ={} ,remove invalidAddress = {} ,wait {} -> active.", new Object[]{serviceID, strBuilder.toString(), invalidWaitTime});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAddress(InterAddress address) {
        Object object = this.poolLock;
        synchronized (object) {
            Set keySet = this.addressPool.keySet();
            for (String bucketKey : keySet) {
                AddressBucket bucket = (AddressBucket)this.addressPool.get(bucketKey);
                if (bucket == null) {
                    return;
                }
                this.logger.debug("service {} removeAddress.", (Object)bucketKey);
                bucket.removeAddress(address);
            }
            this.rulerCache.reset();
        }
    }

    public boolean removeBucket(String serviceID) {
        if (this.addressPool.containsKey(serviceID)) {
            this.logger.info("removeAddressBucket serviceID is {}", (Object)serviceID);
            this.addressPool.remove(serviceID);
            this.rulerCache.reset();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshAddress(String serviceID, List<InterAddress> addressList) {
        Object object = this.poolLock;
        synchronized (object) {
            AddressBucket bucket = (AddressBucket)this.addressPool.get(serviceID);
            if (bucket == null) {
                return;
            }
            this.logger.debug("service {} refreshCache.", (Object)serviceID);
            bucket.refreshAddressToNew(addressList);
        }
        this.rulerCache.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshAddressCache() {
        Object object = this.poolLock;
        synchronized (object) {
            Set keySet = this.addressPool.keySet();
            for (String bucketKey : keySet) {
                AddressBucket bucket = (AddressBucket)this.addressPool.get(bucketKey);
                if (bucket == null) {
                    return;
                }
                this.logger.debug("service {} refreshCache.", (Object)bucketKey);
                bucket.refreshAddress();
            }
            this.rulerCache.reset();
        }
    }

    public InterAddress nextAddress(String serviceID, String methodName, Object[] args) {
        boolean check;
        AddressBucket bucket = (AddressBucket)this.addressPool.get(serviceID);
        if (bucket == null) {
            return null;
        }
        List<InterAddress> addresses = this.rulerCache.getAddressList(serviceID, methodName, args);
        if (addresses == null || addresses.isEmpty()) {
            return null;
        }
        InterAddress doCallAddress = null;
        FlowControlRef flowControlRef = bucket.getFlowControlRef();
        if (flowControlRef == null) {
            throw new NullPointerException("flowControlRef is null.");
        }
        doCallAddress = flowControlRef.randomFlowControl.getServiceAddress(addresses);
        while (!(check = flowControlRef.speedFlowControl.callCheck(serviceID, methodName, doCallAddress))) {
        }
        return doCallAddress;
    }

    protected ArgsKey getArgsKey() {
        return this.argsKey;
    }

    protected RuleRef getRefRule(String serviceID) {
        AddressBucket bucket = (AddressBucket)this.addressPool.get(serviceID);
        RuleRef ruleRef = null;
        if (bucket != null && bucket.getRuleRef() != null) {
            ruleRef = bucket.getRuleRef();
        }
        return ruleRef;
    }

    public String toString() {
        return "AddressPool[" + this.unitName + "]";
    }

    @Override
    public boolean updateServiceRoute(String serviceID, String scriptBody) {
        return this.updateRoute(serviceID, RouteTypeEnum.ServiceLevel, scriptBody);
    }

    @Override
    public boolean updateMethodRoute(String serviceID, String scriptBody) {
        return this.updateRoute(serviceID, RouteTypeEnum.MethodLevel, scriptBody);
    }

    @Override
    public boolean updateArgsRoute(String serviceID, String scriptBody) {
        return this.updateRoute(serviceID, RouteTypeEnum.ArgsLevel, scriptBody);
    }

    @Override
    public boolean updateFlowControl(String serviceID, String flowControl) {
        if (StringUtils.isBlank((String)serviceID)) {
            return false;
        }
        AddressBucket bucket = (AddressBucket)this.addressPool.get(serviceID);
        if (bucket == null) {
            this.logger.warn("update flowControl service={} -> AddressBucket not exist.", (Object)serviceID);
            return false;
        }
        this.logger.info("update flowControl service={} -> update ok", (Object)serviceID);
        bucket.updateFlowControl(flowControl);
        this.refreshAddressCache();
        return true;
    }

    public boolean updateRoute(String serviceID, RouteTypeEnum routeType, String script) {
        AddressBucket bucket = (AddressBucket)this.addressPool.get(serviceID);
        if (bucket == null) {
            this.logger.warn("update rules service={} -> AddressBucket not exist.", (Object)serviceID);
            return false;
        }
        this.logger.info("update rules service={} -> update ok", (Object)serviceID);
        bucket.updateRoute(routeType, script);
        this.refreshAddressCache();
        return true;
    }

    @Override
    public String serviceRoute(String serviceID) {
        AddressBucket bucket = (AddressBucket)this.addressPool.get(serviceID);
        if (bucket == null) {
            return null;
        }
        return AddressPool.getServiceRouteByRef(bucket.getRuleRef());
    }

    @Override
    public String methodRoute(String serviceID) {
        AddressBucket bucket = (AddressBucket)this.addressPool.get(serviceID);
        if (bucket == null) {
            return null;
        }
        return AddressPool.getMethodRouteByRef(bucket.getRuleRef());
    }

    @Override
    public String argsRoute(String serviceID) {
        AddressBucket bucket = (AddressBucket)this.addressPool.get(serviceID);
        if (bucket == null) {
            return null;
        }
        return AddressPool.getArgsRouteByRef(bucket.getRuleRef());
    }

    @Override
    public String flowControl(String serviceID) {
        AddressBucket bucket = (AddressBucket)this.addressPool.get(serviceID);
        if (bucket == null) {
            return null;
        }
        return AddressPool.getFlowControlByRef(bucket.getFlowControlRef());
    }

    @Override
    public List<InterAddress> queryAllAddresses(String serviceID) {
        AddressBucket bucket = (AddressBucket)this.addressPool.get(serviceID);
        if (bucket == null) {
            return null;
        }
        return Collections.unmodifiableList(bucket.getAllAddresses());
    }

    @Override
    public List<InterAddress> queryAvailableAddresses(String serviceID) {
        AddressBucket bucket = (AddressBucket)this.addressPool.get(serviceID);
        if (bucket == null) {
            return null;
        }
        return Collections.unmodifiableList(bucket.getAvailableAddresses());
    }

    @Override
    public List<InterAddress> queryInvalidAddresses(String serviceID) {
        AddressBucket bucket = (AddressBucket)this.addressPool.get(serviceID);
        if (bucket == null) {
            return null;
        }
        return Collections.unmodifiableList(bucket.getInvalidAddresses());
    }

    @Override
    public List<InterAddress> queryLocalUnitAddresses(String serviceID) {
        AddressBucket bucket = (AddressBucket)this.addressPool.get(serviceID);
        if (bucket == null) {
            return null;
        }
        return Collections.unmodifiableList(bucket.getLocalUnitAddresses());
    }

    private static String getFlowControlByRef(FlowControlRef ruleRef) {
        if (ruleRef == null || ruleRef.flowControlScript == null) {
            return null;
        }
        return ruleRef.flowControlScript;
    }

    private static String getArgsRouteByRef(RuleRef ruleRef) {
        if (ruleRef == null || ruleRef.getArgsLevel() == null) {
            return null;
        }
        return ruleRef.getArgsLevel().getScript();
    }

    private static String getMethodRouteByRef(RuleRef ruleRef) {
        if (ruleRef == null || ruleRef.getMethodLevel() == null) {
            return null;
        }
        return ruleRef.getMethodLevel().getScript();
    }

    private static String getServiceRouteByRef(RuleRef ruleRef) {
        if (ruleRef == null || ruleRef.getServiceLevel() == null) {
            return null;
        }
        return ruleRef.getServiceLevel().getScript();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void storeConfig(OutputStream outStream) throws IOException {
        this.logger.info("rsf - saveAddress to stream.");
        ZipOutputStream zipStream = null;
        try {
            zipStream = new ZipOutputStream(outStream);
            Object object = this.poolLock;
            synchronized (object) {
                for (AddressBucket bucket : this.addressPool.values()) {
                    if (bucket == null) continue;
                    String serviceID = bucket.getServiceID() + ".zip";
                    this.logger.debug("rsf - service saveAddress {} storage to snapshot.", (Object)serviceID);
                    ZipEntry entry = new ZipEntry(serviceID);
                    entry.setComment("service config of " + serviceID);
                    zipStream.putNextEntry(entry);
                    bucket.saveToZip(zipStream);
                    zipStream.closeEntry();
                }
            }
        }
        catch (IOException e) {
            this.logger.error("rsf - saveAddress " + e.getClass().getSimpleName() + " :" + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (zipStream != null) {
                zipStream.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void restoreConfig(InputStream inStream) throws IOException {
        ZipInputStream zipStream = new ZipInputStream(inStream);
        try {
            Object object = this.poolLock;
            synchronized (object) {
                ZipEntry zipEntry = null;
                while ((zipEntry = zipStream.getNextEntry()) != null) {
                    String serviceID = zipEntry.getName();
                    AddressBucket bucket = (AddressBucket)this.addressPool.get(serviceID = FilenameUtils.getBaseName((String)serviceID));
                    if (bucket == null) continue;
                    bucket.readFromZip(zipStream);
                    zipStream.closeEntry();
                }
            }
        }
        catch (Exception e) {
            this.logger.error("read the snapshot file error :" + e.getMessage(), (Throwable)e);
        }
    }
}

