/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.rsf.address;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.hasor.rsf.InterAddress;
import net.hasor.rsf.address.AddressPool;
import net.hasor.rsf.address.InnerRuleEngine;
import net.hasor.rsf.address.RuleRef;
import net.hasor.rsf.address.route.rule.ArgsKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AddressCacheResult {
    protected static Logger logger = LoggerFactory.getLogger(AddressCacheResult.class);
    private volatile CacheResult cacheResultRef;
    private final AddressPool addressPool;

    public AddressCacheResult(AddressPool addressPool) {
        this.addressPool = Objects.requireNonNull(addressPool);
    }

    public List<InterAddress> getAddressList(String serviceID, String methodName, Object[] args) {
        Map<String, List<InterAddress>> cacheList;
        String key;
        Map<String, List<InterAddress>> cacheList2;
        Map<String, Map<String, List<InterAddress>>> methodList;
        if (this.cacheResultRef == null) {
            logger.warn("getAddressList fail. resultRef is null.");
            return null;
        }
        List<InterAddress> result = null;
        CacheResult resultRef = this.cacheResultRef;
        ArgsKey argsKeyBuilder = this.addressPool.getArgsKey();
        if (argsKeyBuilder != null && (methodList = resultRef.argsLevel.get(serviceID)) != null && (cacheList2 = methodList.get(methodName)) != null && (key = argsKeyBuilder.eval(serviceID, methodName, args)) != null) {
            result = cacheList2.get(key);
        }
        if (result == null && (cacheList = resultRef.methodLevel.get(serviceID)) != null) {
            result = cacheList.get(methodName);
        }
        if (result == null) {
            result = resultRef.serviceLevel.get(serviceID);
        }
        return result;
    }

    public void reset() {
        logger.info("reset addressCache.");
        Map<String, List<InterAddress>> allAddress = this.addressPool.allServiceAddressToSnapshot();
        Set<String> allServiceIDs = this.addressPool.getBucketNames();
        CacheResult cacheResultRef = new CacheResult();
        for (String serviceID : allServiceIDs) {
            List<InterAddress> all = allAddress.get(serviceID);
            List<InterAddress> unit = allAddress.get(serviceID + "_UNIT");
            List<String> allStrList = AddressCacheResult.convertToStr(all);
            RuleRef refRule = this.addressPool.getRefRule(serviceID);
            List<InterAddress> serviceLevelResult = null;
            if (!refRule.getServiceLevel().isEnable()) {
                logger.debug("eval routeScript [ServiceLevel], service {} route undefined.", (Object)serviceID);
            } else {
                List<String> serviceLevelResultStr = this.evalServiceLevel(serviceID, refRule, allStrList);
                if (serviceLevelResultStr != null && !serviceLevelResultStr.isEmpty()) {
                    serviceLevelResult = AddressCacheResult.convertToAddress(all, serviceLevelResultStr);
                }
            }
            if (serviceLevelResult == null || serviceLevelResult.isEmpty()) {
                serviceLevelResult = unit;
            }
            cacheResultRef.serviceLevel.put(serviceID, serviceLevelResult);
            if (!refRule.getMethodLevel().isEnable()) {
                logger.debug("eval routeScript [MethodLevel], service {} route undefined.", (Object)serviceID);
            } else {
                Map<String, List<String>> methodLevelResultStr = this.evalMethodLevel(serviceID, refRule, allStrList);
                if (methodLevelResultStr != null && !methodLevelResultStr.isEmpty()) {
                    Map<String, List<InterAddress>> methodLevelResult = AddressCacheResult.convertToAddressMethod(all, methodLevelResultStr);
                    cacheResultRef.methodLevel.put(serviceID, methodLevelResult);
                }
            }
            if (!refRule.getArgsLevel().isEnable()) {
                logger.debug("eval routeScript [ArgsLevel], service {} route undefined.", (Object)serviceID);
                continue;
            }
            if (this.addressPool.getArgsKey() == null) {
                logger.error("argsKeyBuilder is null , evalArgsLevel failed.");
                continue;
            }
            Map<String, Map<String, List<String>>> argsLevelResultStr = this.evalArgsLevel(serviceID, refRule, allStrList);
            if (argsLevelResultStr == null || argsLevelResultStr.isEmpty()) continue;
            Map<String, Map<String, List<InterAddress>>> argsLevelResult = AddressCacheResult.convertToAddressArgs(all, argsLevelResultStr);
            cacheResultRef.argsLevel.put(serviceID, argsLevelResult);
        }
        logger.debug("switch cacheResultRef.");
        this.cacheResultRef = cacheResultRef;
    }

    private static Map<String, Map<String, List<InterAddress>>> convertToAddressArgs(List<InterAddress> all, Map<String, Map<String, List<String>>> argsLevelResult) {
        HashMap<String, Map<String, List<InterAddress>>> result = new HashMap<String, Map<String, List<InterAddress>>>();
        for (Map.Entry<String, Map<String, List<String>>> ent : argsLevelResult.entrySet()) {
            String key = ent.getKey();
            Map<String, List<InterAddress>> val = AddressCacheResult.convertToAddressMethod(all, ent.getValue());
            if (val == null || val.isEmpty()) continue;
            result.put(key, val);
        }
        return result;
    }

    private static Map<String, List<InterAddress>> convertToAddressMethod(List<InterAddress> all, Map<String, List<String>> methodLevelResult) {
        HashMap<String, List<InterAddress>> result = new HashMap<String, List<InterAddress>>();
        for (Map.Entry<String, List<String>> ent : methodLevelResult.entrySet()) {
            String key = ent.getKey();
            List<InterAddress> val = AddressCacheResult.convertToAddress(all, ent.getValue());
            if (val == null || val.isEmpty()) continue;
            result.put(key, val);
        }
        return result;
    }

    private static List<InterAddress> convertToAddress(List<InterAddress> all, List<String> serviceLevelResult) {
        ArrayList<InterAddress> result = new ArrayList<InterAddress>(serviceLevelResult.size());
        for (String evalResult : serviceLevelResult) {
            for (InterAddress address : all) {
                try {
                    if (!address.equalsHost(evalResult)) continue;
                    result.add(address);
                }
                catch (Exception e) {
                    logger.info(e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    private static List<String> convertToStr(List<InterAddress> all) {
        ArrayList<String> result = new ArrayList<String>();
        for (InterAddress address : all) {
            try {
                result.add(address.getHostPort());
            }
            catch (Exception e) {
                logger.info(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private List<String> evalServiceLevel(String serviceID, RuleRef refRule, List<String> all) {
        InnerRuleEngine serviceLevel = refRule.getServiceLevel();
        if (serviceLevel == null) {
            return null;
        }
        try {
            Object result = serviceLevel.runRule(serviceID, all);
            return (List)result;
        }
        catch (Throwable e) {
            logger.error("evalServiceLevel error ,message = " + e.getMessage(), e);
            return null;
        }
    }

    private Map<String, List<String>> evalMethodLevel(String serviceID, RuleRef refRule, List<String> all) {
        InnerRuleEngine methodLevel = refRule.getMethodLevel();
        if (methodLevel == null) {
            return null;
        }
        try {
            Object result = methodLevel.runRule(serviceID, all);
            return (Map)result;
        }
        catch (Throwable e) {
            logger.error("evalMethodLevel error ,message = " + e.getMessage(), e);
            return null;
        }
    }

    private Map<String, Map<String, List<String>>> evalArgsLevel(String serviceID, RuleRef refRule, List<String> all) {
        InnerRuleEngine argsLevel = refRule.getArgsLevel();
        if (argsLevel == null) {
            return null;
        }
        try {
            Object result = argsLevel.runRule(serviceID, all);
            return (Map)result;
        }
        catch (Throwable e) {
            logger.error("evalArgsLevel error ,message = " + e.getMessage(), e);
            return null;
        }
    }

    private static class CacheResult {
        public final Map<String, List<InterAddress>> serviceLevel = new HashMap<String, List<InterAddress>>();
        public final Map<String, Map<String, List<InterAddress>>> methodLevel = new HashMap<String, Map<String, List<InterAddress>>>();
        public final Map<String, Map<String, Map<String, List<InterAddress>>>> argsLevel = new HashMap<String, Map<String, Map<String, List<InterAddress>>>>();
    }
}

