/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.core;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.more.util.ClassUtils;

class InnerCallableStatementGetter {
    InnerCallableStatementGetter() {
    }

    public static Object getValue(CallableStatement cs, int index, Class<?> requiredType) throws SQLException {
        Object value = null;
        boolean wasNullCheck = false;
        if (requiredType == null) {
            return cs.getObject(index);
        }
        if (String.class.equals((Object)(requiredType = ClassUtils.primitiveToWrapper(requiredType)))) {
            value = cs.getString(index);
        } else if (Integer.class.equals((Object)requiredType)) {
            value = cs.getInt(index);
            wasNullCheck = true;
        } else if (Double.class.equals((Object)requiredType)) {
            value = new Double(cs.getDouble(index));
            wasNullCheck = true;
        } else if (Boolean.class.equals((Object)requiredType)) {
            value = cs.getBoolean(index) ? Boolean.TRUE : Boolean.FALSE;
            wasNullCheck = true;
        } else if (java.sql.Date.class.equals((Object)requiredType)) {
            value = cs.getDate(index);
        } else if (Time.class.equals((Object)requiredType)) {
            value = cs.getTime(index);
        } else if (Timestamp.class.equals((Object)requiredType)) {
            value = cs.getTimestamp(index);
        } else if (Date.class.equals((Object)requiredType)) {
            value = new Date(cs.getTimestamp(index).getTime());
        } else if (Byte.class.equals((Object)requiredType)) {
            value = cs.getByte(index);
            wasNullCheck = true;
        } else if (Short.class.equals((Object)requiredType)) {
            value = cs.getShort(index);
            wasNullCheck = true;
        } else if (Long.class.equals((Object)requiredType)) {
            value = cs.getLong(index);
            wasNullCheck = true;
        } else if (Float.class.equals((Object)requiredType)) {
            value = new Float(cs.getFloat(index));
            wasNullCheck = true;
        } else if (Number.class.equals((Object)requiredType)) {
            value = new Double(cs.getDouble(index));
            wasNullCheck = true;
        } else {
            value = byte[].class.equals((Object)requiredType) ? (Object)cs.getBytes(index) : (BigDecimal.class.equals((Object)requiredType) ? cs.getBigDecimal(index) : (Blob.class.equals((Object)requiredType) ? cs.getBlob(index) : (Clob.class.equals((Object)requiredType) ? cs.getClob(index) : (URL.class.equals((Object)requiredType) ? cs.getURL(index) : cs.getObject(index)))));
        }
        if (wasNullCheck && value != null && cs.wasNull()) {
            value = null;
        }
        return value;
    }
}

