package net.gplatform.spring.social.qq.connect;

/*
 * #%L
 * spring-social-qq
 * %%
 * Copyright (C) 2013 - 2014 Shark Xu
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.social.oauth2.OAuth2Template;
import org.springframework.social.support.FormMapHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class QQOAuth2Template extends OAuth2Template {

	private static final Log logger = LogFactory.getLog(QQOAuth2Template.class.getName());

	public QQOAuth2Template(String clientId, String clientSecret, String authorizeUrl, String accessTokenUrl) {
		super(clientId, clientSecret, authorizeUrl, accessTokenUrl);
	}

	@Override
	protected RestTemplate createRestTemplate() {
		RestTemplate restTemplate =super.createRestTemplate();
		
		HttpMessageConverter<?> messageConverter = new FormMapHttpMessageConverter() {
			@Override
			public boolean canRead(Class<?> clazz, MediaType mediaType) {
				boolean result = false;
				if(mediaType == null){
					return result;
				}
				result = MediaType.TEXT_HTML.isCompatibleWith(mediaType);
				return result;
			}
		};
		
		restTemplate.getMessageConverters().add(messageConverter);

		return restTemplate;
	}

}
