/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.gplatform.spring.social.qq.connect;

/*
 * #%L
 * spring-social-qq
 * %%
 * Copyright (C) 2013 - 2014 Shark Xu
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import net.gplatform.spring.social.qq.api.QQ;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.social.connect.ApiAdapter;
import org.springframework.social.connect.ConnectionValues;
import org.springframework.social.connect.UserProfile;
import org.springframework.social.connect.UserProfileBuilder;

import com.qq.connect.javabeans.qzone.UserInfoBean;

public class QQAdapter implements ApiAdapter<QQ> {
	private static final Logger LOG = LoggerFactory.getLogger(QQAdapter.class);

	@Override
	public boolean test(QQ api) {
		try {
			api.qzoneUserInfoOperations().getUserInfo();
			return true;
		} catch (Exception e) {
			LOG.debug("", e);
			return false;
		}
	}

	@Override
	public void setConnectionValues(QQ api, ConnectionValues values) {
		try {
			values.setProviderUserId(api.getUserOpenID());
			
			UserInfoBean uib = api.qzoneUserInfoOperations().getUserInfo();
			values.setDisplayName(uib.getNickname());
			values.setProfileUrl(uib.getAvatar().getAvatarURL50());
			values.setImageUrl(uib.getAvatar().getAvatarURL50());
		} catch (Exception e) {
			LOG.error("error setConnectionValues", e);
		}
	}

	@Override
	public UserProfile fetchUserProfile(QQ api) {
		try {
			UserInfoBean uib = api.qzoneUserInfoOperations().getUserInfo();
			return new UserProfileBuilder().setName(uib.getNickname()).setUsername(uib.getNickname()).build();
		} catch (Exception e) {
			LOG.error("error fetchUserProfile", e);
		}
		return null;

	}

	@Override
	public void updateStatus(QQ api, String message) {
		try {
			api.weiboOperations().addWeibo(message);
		} catch (Exception e) {
			LOG.error("error updateStatus", e);
		}
	}

}
