/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.error;

import java.util.Locale;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import net.dreamlu.tool.exception.LocalizedException;
import net.dreamlu.tool.exception.ServiceException;
import net.dreamlu.tool.result.Result;
import net.dreamlu.tool.result.Results;
import net.dreamlu.tool.util.Exceptions;
import net.dreamlu.tool.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.NoHandlerFoundException;

public class ExceptionTranslator {
    private static final Logger log = LoggerFactory.getLogger(ExceptionTranslator.class);
    private final MessageSource messageSource;

    public Result<String> handle(Throwable error) {
        Locale locale = LocaleContextHolder.getLocale();
        Throwable _error = Exceptions.unwrap((Throwable)error);
        return this.handleException(_error, locale);
    }

    protected Result<String> handleException(Throwable error, Locale locale) {
        if (error instanceof MissingServletRequestParameterException) {
            return this.handleError((MissingServletRequestParameterException)error, locale);
        }
        if (error instanceof MethodArgumentNotValidException) {
            return this.handleError((MethodArgumentNotValidException)error);
        }
        if (error instanceof MethodArgumentTypeMismatchException) {
            return this.handleError((MethodArgumentTypeMismatchException)error);
        }
        if (error instanceof HttpMessageNotReadableException) {
            return this.handleError((HttpMessageNotReadableException)error);
        }
        if (error instanceof BindException) {
            return this.handleError((BindException)error);
        }
        if (error instanceof ConstraintViolationException) {
            return this.handleError((ConstraintViolationException)error);
        }
        if (error instanceof NoHandlerFoundException) {
            return this.handleError((NoHandlerFoundException)error, locale);
        }
        if (error instanceof HttpRequestMethodNotSupportedException) {
            return this.handleError((HttpRequestMethodNotSupportedException)error, locale);
        }
        if (error instanceof HttpMediaTypeNotSupportedException) {
            return this.handleError((HttpMediaTypeNotSupportedException)error, locale);
        }
        if (error instanceof LocalizedException) {
            return this.handleError((LocalizedException)error, locale);
        }
        if (error instanceof ServiceException) {
            return this.handleError((ServiceException)error, locale);
        }
        return this.handleError(error, locale);
    }

    protected Result<String> handleError(MissingServletRequestParameterException e, Locale locale) {
        log.error("\u7f3a\u5c11\u8bf7\u6c42\u53c2\u6570", (Throwable)e);
        String parameterName = e.getParameterName();
        String parameterType = e.getParameterType();
        return this.getMessage((Throwable)e, locale, new Object[]{parameterName, parameterType});
    }

    protected Result<String> handleError(MethodArgumentNotValidException e) {
        log.error("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25", (Throwable)e);
        BindingResult result = e.getBindingResult();
        FieldError error = result.getFieldError();
        return Results.failure((String)error.getDefaultMessage());
    }

    protected Result<String> handleError(MethodArgumentTypeMismatchException e) {
        log.error("\u53c2\u6570\u7c7b\u578b\u9519\u8bef", (Throwable)e);
        return Results.failure((String)String.format("%s \u53c2\u6570\u7c7b\u578b\u9519\u8bef", e.getName()));
    }

    protected Result<String> handleError(HttpMessageNotReadableException e) {
        log.error("\u6d88\u606f\u4e0d\u80fd\u89e3\u6790", (Throwable)e);
        return Results.failure((String)"\u6d88\u606f\u4e0d\u80fd\u89e3\u6790");
    }

    protected Result<String> handleError(BindException e) {
        log.error("\u53c2\u6570\u7ed1\u5b9a\u5931\u8d25", (Throwable)e);
        BindingResult result = e.getBindingResult();
        FieldError error = result.getFieldError();
        return Results.failure((String)error.getDefaultMessage());
    }

    protected Result<String> handleError(ConstraintViolationException e) {
        log.error("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25", (Throwable)e);
        Set violations = e.getConstraintViolations();
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        return Results.failure((String)violation.getMessage());
    }

    protected Result<String> handleError(NoHandlerFoundException e, Locale locale) {
        log.error("404\u6ca1\u627e\u5230\u8bf7\u6c42", (Throwable)e);
        String httpMethod = e.getHttpMethod();
        String requestURL = e.getRequestURL();
        return this.getMessage((Throwable)e, locale, new Object[]{httpMethod, requestURL});
    }

    protected Result<String> handleError(HttpRequestMethodNotSupportedException e, Locale locale) {
        log.error("\u4e0d\u652f\u6301\u5f53\u524d\u8bf7\u6c42\u65b9\u6cd5", (Throwable)e);
        String method = e.getMethod();
        return this.getMessage((Throwable)e, locale, new Object[]{method});
    }

    protected Result<String> handleError(HttpMediaTypeNotSupportedException e, Locale locale) {
        log.error("\u4e0d\u652f\u6301\u5f53\u524d\u5a92\u4f53\u7c7b\u578b", (Throwable)e);
        MediaType contentType = e.getContentType();
        return this.getMessage((Throwable)e, locale, new Object[]{contentType.getType()});
    }

    protected Result<String> handleError(LocalizedException e, Locale locale) {
        log.error("\u672c\u5730\u5316\u5f02\u5e38", (Throwable)e);
        return this.getMessage((Throwable)e, locale, e.getLocaleArgs());
    }

    protected Result<String> handleError(ServiceException e, Locale locale) {
        log.error("\u672c\u5730\u5316\u5f02\u5e38", (Throwable)e);
        return e.getResult();
    }

    protected Result<String> handleError(Throwable e, Locale locale) {
        log.error("\u901a\u7528\u5f02\u5e38", e);
        return this.getMessage(e, locale, new Object[0]);
    }

    protected Result<String> getMessage(Throwable e, Locale locale, Object[] values) {
        String message;
        String msgKey = e instanceof LocalizedException ? ((LocalizedException)e).getLocaleMessage() : e.getClass().getName();
        try {
            message = this.messageSource.getMessage(msgKey, values, locale);
        }
        catch (NoSuchMessageException ex) {
            log.warn(ex.getMessage());
            message = e.getMessage();
        }
        if (StringUtils.isBlank((CharSequence)message)) {
            message = "\u7cfb\u7edf\u5f02\u5e38";
        }
        return Results.failure((String)message);
    }

    public ExceptionTranslator(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

