/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.config;

import net.dreamlu.boot.properties.DreamMessagesProperties;
import org.hibernate.validator.HibernateValidator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.validation.beanvalidation.MethodValidationPostProcessor;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@AutoConfigureAfter(value={DreamMessagesProperties.class})
public class ValidatorConfiguration
extends WebMvcConfigurerAdapter {
    private final DreamMessagesProperties properties;

    public Validator getValidator() {
        LocalValidatorFactoryBean validator = new LocalValidatorFactoryBean();
        validator.setProviderClass(HibernateValidator.class);
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasename(this.properties.getValidator().getBasename());
        messageSource.setCacheSeconds(this.properties.getCacheSeconds());
        messageSource.setDefaultEncoding(this.properties.getEncoding().name());
        messageSource.setAlwaysUseMessageFormat(this.properties.isAlwaysUseMessageFormat());
        messageSource.setFallbackToSystemLocale(this.properties.isFallbackToSystemLocale());
        validator.setValidationMessageSource((MessageSource)messageSource);
        return validator;
    }

    @Bean
    public MethodValidationPostProcessor methodValidationPostProcessor() {
        return new MethodValidationPostProcessor();
    }

    public ValidatorConfiguration(DreamMessagesProperties properties) {
        this.properties = properties;
    }
}

