/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.config;

import net.dreamlu.boot.properties.DreamProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;

@Configuration
public class LocaleConfiguration
extends WebMvcConfigurerAdapter {
    private final DreamProperties dreamProperties;

    @Bean
    @ConditionalOnMissingBean(value={LocaleResolver.class}, search=SearchStrategy.CURRENT)
    public LocaleResolver localeResolver() {
        CookieLocaleResolver localeResolver = new CookieLocaleResolver();
        localeResolver.setDefaultLocale(this.dreamProperties.getLocale().getDefaultLocale());
        localeResolver.setCookieName(this.dreamProperties.getLocale().getCookieName());
        return localeResolver;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        LocaleChangeInterceptor localeChangeInterceptor = new LocaleChangeInterceptor();
        localeChangeInterceptor.setParamName(this.dreamProperties.getLocale().getParamName());
        registry.addInterceptor((HandlerInterceptor)localeChangeInterceptor);
    }

    public LocaleConfiguration(DreamProperties dreamProperties) {
        this.dreamProperties = dreamProperties;
    }
}

