/*
 * *************************************************************************
 *   Copyright (c) 2018-2025, dreamlu.net All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the dreamlu.net developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: chunmeng.lu (qq596392912@gmail.com)
 * *************************************************************************
 */

package net.dreamlu.boot.runer;

import lombok.extern.slf4j.Slf4j;
import net.dreamlu.tool.util.StringUtils;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;

/**
 * 项目启动事件通知
 *
 * @author L.cm
 */
@Slf4j
public class StartEventListener {

	@Async
	@Order
	@EventListener(EmbeddedServletContainerInitializedEvent.class)
	public void afterStart(EmbeddedServletContainerInitializedEvent event) {
		String[] profiles = event.getApplicationContext().getEnvironment().getActiveProfiles();
		String profile = StringUtils.join(profiles);
		log.info("----项目启动完成，当前使用的环境变量:[{}]----", profile);
	}
}
