/*
 * *************************************************************************
 *   Copyright (c) 2018-2025, dreamlu.net All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the dreamlu.net developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: chunmeng.lu (qq596392912@gmail.com)
 * *************************************************************************
 */

package net.dreamlu.boot.properties;

import lombok.Getter;
import lombok.Setter;
import net.dreamlu.tool.util.Exceptions;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.nio.charset.Charset;

/**
 * messages配置
 *
 * @author L.cm
 */
@ConfigurationProperties("dream.messages")
public class DreamMessagesProperties {

	/**
	 * Message bundles encoding.
	 */
	@Getter
	@Setter
	private Charset encoding = Charset.forName("UTF-8");

	/**
	 * Files cache seconds. When set to -1 cached forever.
	 */
	@Getter
	@Setter
	private int cacheSeconds = -1;

	/**
	 * fall back to the system Locale if no files
	 */
	@Getter
	@Setter
	private boolean fallbackToSystemLocale = true;

	/**
	 * MessageFormat rules
	 */
	@Getter
	@Setter
	private boolean alwaysUseMessageFormat = false;

	@Getter
	private final Validator validator = new Validator();

	/**
	 * Bean Validator messages配置
	 */
	@Getter
	@Setter
	public static class Validator {
		/**
		 * Bean Validator basename，默认：ValidationMessages，使用hibernate-validator自带
		 */
		private String basename = "ValidationMessages";
	}

	@Getter
	private final ExceptionMessages exception = new ExceptionMessages();

	/**
	 * Exception messages配置
	 */
	@Getter
	@Setter
	public static class ExceptionMessages {
		/**
		 * Exception basename，默认：ValidationMessages，使用hibernate-validator自带
		 */
		private String basename = "messages/errorMessages";
	}

}
