/*
 * *************************************************************************
 *   Copyright (c) 2018-2025, dreamlu.net All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the dreamlu.net developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: chunmeng.lu (qq596392912@gmail.com)
 * *************************************************************************
 */

package net.dreamlu.boot.config;

import lombok.AllArgsConstructor;
import net.dreamlu.boot.properties.DreamProperties;
import net.dreamlu.tool.captcha.DreamCaptcha;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 验证码配置
 *
 * @author L.cm
 */
@Configuration
@ConditionalOnWebApplication
@AutoConfigureAfter(DreamProperties.class)
@ConditionalOnProperty(value = "dream.captcha.enabled", havingValue = "true")
@AllArgsConstructor
public class CaptchaConfiguration {
	private final DreamProperties dreamProperties;

	@Bean
	public DreamCaptcha dreamCaptcha(CacheManager cacheManager) {
		DreamCaptcha captcha = new DreamCaptcha(cacheManager);
		captcha.setCacheName(dreamProperties.getCaptcha().getCacheName());
		captcha.setCookieName(dreamProperties.getCaptcha().getCookieName());
		return captcha;
	}
}
