/*
 * *************************************************************************
 *   Copyright (c) 2018-2025, dreamlu.net All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the dreamlu.net developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: chunmeng.lu (qq596392912@gmail.com)
 * *************************************************************************
 */

;var window = {};
!function(){
"use strict";

var config = {
  open: _config.open,
  close: _config.close
};

var tool = {
  exp: function(str){
    return new RegExp(str, 'g');
  },
  query: function(type, _, __){
    var types = [
      '#([\\s\\S])+?',
      '([^{#}])*?'
    ][type || 0];
    return exp((_||'') + config.open + types + config.close + (__||''));
  },
  escape: function(html){
    return String(html||'').replace(/&(?!#?[a-zA-Z0-9]+;)/g, '&amp;')
    .replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/'/g, '&#39;').replace(/"/g, '&quot;');
  },
  error: function(e, tplog){
    var error = 'Laytpl Error：';
    typeof console === 'object' && console.error(error + e + '\n'+ (tplog || ''));
    return error + e;
  }
};

var exp = tool.exp, Tpl = function(tpl){
  this.tpl = tpl;
};

Tpl.pt = Tpl.prototype;

window.errors = 0;

Tpl.pt.parse = function(tpl, data){
  var that = this, tplog = tpl;
  var jss = exp('^'+config.open+'#', ''), jsse = exp(config.close+'$', '');

  tpl = tpl.replace(/\s+|\r|\t|\n/g, ' ').replace(exp(config.open+'#'), config.open+'# ')

  .replace(exp(config.close+'}'), '} '+config.close).replace(/\\/g, '\\\\')

  .replace(/(?="|')/g, '\\').replace(tool.query(), function(str){
    str = str.replace(jss, '').replace(jsse, '');
    return '";' + str.replace(/\\/g, '') + ';view+="';
  })

  .replace(tool.query(1), function(str){
    var start = '"+(';
    if(str.replace(/\s/g, '') === config.open+config.close){
      return '';
    }
    str = str.replace(exp(config.open+'|'+config.close), '');
    if(/^=/.test(str)){
      str = str.replace(/^=/, '');
      start = '"+_escape_(';
    }
    return start + str.replace(/\\/g, '') + ')+"';
  });

  tpl = '"use strict";var view = "' + tpl + '";return view;';
  tpl = tpl.replace(/\\\\/g, '\\');
  // console.log(tpl);

  try{
    that.cache = tpl = new Function('d, _escape_', tpl);
    return tpl(data, tool.escape);
  } catch(e){
    delete that.cache;
    return tool.error(e, tplog);
  }
};

Tpl.pt.render = function(data, callback){
  var that = this, tpl;
  if(!data) return tool.error('no data');
  tpl = that.cache ? that.cache(data, tool.escape) : that.parse(that.tpl, data);

  if(!callback) return tpl;
  callback(tpl);
};

var laytpl = function(tpl){
  if(typeof tpl !== 'string') return tool.error('Template not found');
  return new Tpl(tpl);
};

laytpl.v = '1.2';

"function" == typeof define ? define(function() {
  return laytpl
}) : "undefined" != typeof exports ? module.exports = laytpl : window.laytpl = laytpl

}();

var laytpl = window.laytpl;
