/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.properties;

import java.util.HashMap;
import java.util.Map;
import net.dreamlu.boot.properties.DreamDefaults;
import net.dreamlu.tool.util.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="dream")
public class DreamProperties {
    private String env;
    private String name;
    private final Map<String, String> prop = new HashMap<String, String>();
    private final Mvc mvc = new Mvc();
    private final Login login = new Login();
    private final Async async = new Async();
    private final Captcha captcha = new Captcha();
    private final Locale locale = new Locale();
    private final Upload upload = new Upload();
    private final Tpl tpl = new Tpl();

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, String defaultValue) {
        String value = this.prop.get(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }

    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    public Integer getInt(String key, Integer defaultValue) {
        String value = this.prop.get(key);
        if (value != null) {
            return Integer.valueOf(value.trim());
        }
        return defaultValue;
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        String value = this.prop.get(key);
        if (value != null) {
            return Long.valueOf(value.trim());
        }
        return defaultValue;
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = this.prop.get(key);
        if (value != null) {
            if ("true".equals(value = value.toLowerCase().trim())) {
                return Boolean.TRUE;
            }
            if ("false".equals(value)) {
                return Boolean.FALSE;
            }
            throw new RuntimeException("The value can not parse to Boolean : " + value);
        }
        return defaultValue;
    }

    public boolean containsKey(String key) {
        return this.prop.containsKey(key);
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getProp() {
        return this.prop;
    }

    public Mvc getMvc() {
        return this.mvc;
    }

    public Login getLogin() {
        return this.login;
    }

    public Async getAsync() {
        return this.async;
    }

    public Captcha getCaptcha() {
        return this.captcha;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Upload getUpload() {
        return this.upload;
    }

    public Tpl getTpl() {
        return this.tpl;
    }

    public static class Tpl {
        private String open = "{{";
        private String close = "}}";
        private String prefix = "classpath:templates/tpl/";
        private boolean cache = true;

        public String getOpen() {
            return this.open;
        }

        public String getClose() {
            return this.close;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public boolean isCache() {
            return this.cache;
        }

        public void setOpen(String open) {
            this.open = open;
        }

        public void setClose(String close) {
            this.close = close;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setCache(boolean cache) {
            this.cache = cache;
        }
    }

    public static class Upload {
        String savePath = DreamDefaults.Upload.savePath;

        public String getSavePath() {
            return this.savePath;
        }

        public void setSavePath(String savePath) {
            this.savePath = savePath;
        }
    }

    public static class Locale {
        private String cookieName = "DREAM-LANG";
        private String paramName = "language";
        private java.util.Locale defaultLocale = DreamDefaults.Locale.defaultLocale;

        public String getCookieName() {
            return this.cookieName;
        }

        public String getParamName() {
            return this.paramName;
        }

        public java.util.Locale getDefaultLocale() {
            return this.defaultLocale;
        }

        public void setCookieName(String cookieName) {
            this.cookieName = cookieName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }

        public void setDefaultLocale(java.util.Locale defaultLocale) {
            this.defaultLocale = defaultLocale;
        }
    }

    public static class Captcha {
        private String cookieName = "dream-captcha";
        private String cacheName = "dreamCaptchaCache";

        public String getCookieName() {
            return this.cookieName;
        }

        public String getCacheName() {
            return this.cacheName;
        }

        public void setCookieName(String cookieName) {
            this.cookieName = cookieName;
        }

        public void setCacheName(String cacheName) {
            this.cacheName = cacheName;
        }
    }

    public static class Async {
        private int corePoolSize = 2;
        private int maxPoolSize = 50;
        private int queueCapacity = 10000;
        private int keepAliveSeconds = 300;

        public int getCorePoolSize() {
            return this.corePoolSize;
        }

        public int getMaxPoolSize() {
            return this.maxPoolSize;
        }

        public int getQueueCapacity() {
            return this.queueCapacity;
        }

        public int getKeepAliveSeconds() {
            return this.keepAliveSeconds;
        }

        public void setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public void setMaxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
        }

        public void setQueueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
        }

        public void setKeepAliveSeconds(int keepAliveSeconds) {
            this.keepAliveSeconds = keepAliveSeconds;
        }
    }

    public static class Login {
        private int retryLimit = 5;
        private String retryLimitCacheName = "retryLimitCache";

        public int getRetryLimit() {
            return this.retryLimit;
        }

        public String getRetryLimitCacheName() {
            return this.retryLimitCacheName;
        }

        public void setRetryLimit(int retryLimit) {
            this.retryLimit = retryLimit;
        }

        public void setRetryLimitCacheName(String retryLimitCacheName) {
            this.retryLimitCacheName = retryLimitCacheName;
        }
    }

    public static class Mvc {
        private String contentType = "application/json;charset=UTF-8";

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }
    }
}

