/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.config;

import java.nio.charset.StandardCharsets;
import java.util.List;
import net.dreamlu.boot.properties.DreamProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.ResourceRegionHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class UploadResourceConfigurtion
extends WebMvcConfigurerAdapter {
    private final DreamProperties dreamProperties;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String path = this.dreamProperties.getUpload().getSavePath();
        registry.addResourceHandler(new String[]{"/upload/**"}).addResourceLocations(new String[]{"file:" + path + "/upload/"});
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        super.configureMessageConverters(converters);
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter(StandardCharsets.UTF_8));
        converters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new ResourceRegionHttpMessageConverter());
    }

    public UploadResourceConfigurtion(DreamProperties dreamProperties) {
        this.dreamProperties = dreamProperties;
    }
}

