/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.config;

import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.dreamlu.boot.properties.DreamProperties;
import net.dreamlu.boot.properties.DreamSwaggerProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.ApiKeyVehicle;
import springfox.documentation.swagger2.configuration.Swagger2DocumentationConfiguration;

@Configuration
@ConditionalOnClass(value={Swagger2DocumentationConfiguration.class, BeanValidatorPluginsConfiguration.class})
@Import(value={Swagger2DocumentationConfiguration.class, BeanValidatorPluginsConfiguration.class})
@AutoConfigureAfter(value={DreamSwaggerProperties.class})
public class SwaggerConfiguration
extends WebMvcConfigurerAdapter {
    private final DreamSwaggerProperties properties;
    private final DreamProperties dreamProperties;

    @Bean
    public Docket createRestApi() {
        String appName = this.dreamProperties.getName();
        Docket docket = new Docket(DocumentationType.SWAGGER_2).useDefaultResponseMessages(false).groupName(appName).globalOperationParameters(this.globalHeaders()).apiInfo(this.apiInfo(appName)).select().apis(RequestHandlerSelectors.withClassAnnotation(Api.class)).paths(PathSelectors.any()).build();
        if (this.properties.getAuthorization().getEnabled().booleanValue()) {
            docket.securitySchemes(Collections.singletonList(this.apiKey()));
            docket.securityContexts(Collections.singletonList(this.securityContext()));
        }
        return docket;
    }

    private ApiKey apiKey() {
        return new ApiKey(this.properties.getAuthorization().getName(), this.properties.getAuthorization().getKeyName(), ApiKeyVehicle.HEADER.getValue());
    }

    private SecurityContext securityContext() {
        return SecurityContext.builder().securityReferences(this.defaultAuth()).forPaths(PathSelectors.regex((String)this.properties.getAuthorization().getAuthRegex())).build();
    }

    private List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        return Collections.singletonList(SecurityReference.builder().reference(this.properties.getAuthorization().getName()).scopes(authorizationScopes).build());
    }

    private ApiInfo apiInfo(String appName) {
        String defaultName = appName.toUpperCase() + "\u670d\u52a1";
        String title = Optional.ofNullable(this.properties.getTitle()).orElse(defaultName);
        String description = Optional.ofNullable(this.properties.getDescription()).orElse(defaultName);
        return new ApiInfoBuilder().title(title).description(description).version(this.properties.getVersion()).contact(new Contact(this.properties.getContactUser(), this.properties.getContactUrl(), this.properties.getContactEmail())).build();
    }

    private List<Parameter> globalHeaders() {
        ArrayList<Parameter> pars = new ArrayList<Parameter>();
        this.properties.getHeaders().forEach(header -> {
            Parameter token = new ParameterBuilder().name(header.getName()).description(header.getDescription()).modelRef((ModelReference)new ModelRef("string")).parameterType("header").required(header.isRequired()).build();
            pars.add(token);
        });
        return pars;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars*"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }

    public SwaggerConfiguration(DreamSwaggerProperties properties, DreamProperties dreamProperties) {
        this.properties = properties;
        this.dreamProperties = dreamProperties;
    }
}

