/*
 * *************************************************************************
 *   Copyright (c) 2018-2025, dreamlu.net All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the dreamlu.net developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: chunmeng.lu (qq596392912@gmail.com)
 * *************************************************************************
 */

package net.dreamlu.boot.properties;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import springfox.documentation.schema.ModelRef;

import java.util.ArrayList;
import java.util.List;

@Getter
@Setter
@ConfigurationProperties("dream.swagger")
public class DreamSwaggerProperties {
	/**
	 * 标题，默认：XXX服务
	 */
	private String title;
	/**
	 * 详情，默认：XXX服务
	 */
	private String description;
	/**
	 * 版本号，默认：V1.0
	 */
	private String version = "V1.0";
	/**
	 * 组织名，默认：Dream
	 */
	private String contactUser = "如梦技术";
	/**
	 * 组织url，默认：https://www.dreamlu.com
	 */
	private String contactUrl = "https://www.dreamlu.net/";
	/**
	 * 组织邮箱，默认：596392912@qq.com
	 */
	private String contactEmail = "596392912@qq.com";
	/**
	 * 全局统一请求头
	 */
	private final List<Header> headers = new ArrayList<>();
	/**
	 * 全局统一鉴权配置
	 **/
	private final Authorization authorization = new Authorization();

	/**
	 * securitySchemes 支持方式之一 ApiKey
	 */
	@Getter
	@Setter
	public static class Authorization {
		/**
		 * 开启Authorization，默认：false
		 */
		private Boolean enabled = false;
		/**
		 * 鉴权策略ID，对应 SecurityReferences ID，默认：Authorization
		 */
		private String name = "Authorization";
		/**
		 * 鉴权传递的Header参数，默认：TOKEN
		 */
		private String keyName = "TOKEN";
		/**
		 * 需要开启鉴权URL的正则，默认：^.*$
		 */
		private String authRegex = "^.*$";
	}

	/**
	 * 全局通用请求头
	 */
	@Getter
	@Setter
	public static class Header {
		/**
		 * 请求头名
		 */
		private String name;
		/**
		 * 请求头描述
		 */
		private String description;
		/**
		 * 是否必须，默认：false
		 */
		private boolean required = false;
	}
}
