/*
 * *************************************************************************
 *   Copyright (c) 2018-2025, dreamlu.net All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the dreamlu.net developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: chunmeng.lu (qq596392912@gmail.com)
 * *************************************************************************
 */

package net.dreamlu.boot.properties;

import lombok.Getter;
import net.dreamlu.tool.util.PathUtils;
import org.springframework.http.MediaType;

import java.util.ArrayList;
import java.util.List;

public interface DreamDefaults {

	interface Mvc {
		String contentType = MediaType.APPLICATION_JSON_UTF8_VALUE;
	}

	interface Login {
		int retryLimit = 5;
		String retryLimitCacheName = "retryLimitCache";
	}

	interface Async {
		int corePoolSize = 2;
		int maxPoolSize = 50;
		int queueCapacity = 10000;
		int keepAliveSeconds = 300;
	}

	interface Captcha {
		String cookieName = "dream-captcha";
		String chacheName = "dreamCaptchaCache";
	}

	interface Locale {
		String cookieName = "DREAM-LANG";
		String paramName = "language";
		java.util.Locale defaultLocale = java.util.Locale.SIMPLIFIED_CHINESE;
	}

	interface Upload {
		String savePath = PathUtils.getJarPath();
	}

	interface Tpl {
		String open = "{{";
		String close = "}}";
		String prefix = "classpath:templates/tpl/";
		boolean cache = true;
	}

	interface HttpCache {
		String chacheName = "dreamHttpCache";
	}
}
