/*
 * *************************************************************************
 *   Copyright (c) 2018-2025, dreamlu.net All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the dreamlu.net developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: chunmeng.lu (qq596392912@gmail.com)
 * *************************************************************************
 */

package net.dreamlu.boot.properties;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.ArrayList;
import java.util.List;

@ConfigurationProperties("dream.cross")
public class DreamCrossProperties {
	@Getter
	private final Cors cors = new Cors();

	/**
	 * Cors跨域
	 */
	@Getter
	@Setter
	public static class Cors {
		/**
		 * cors mapping，默认：/**
		 */
		private String mapping = "/**";
		/**
		 * 允许的来源，默认：*
		 */
		private List<String> allowedOrigins = new ArrayList<String>(){{ add("*"); }};
		/**
		 * 允许的methods，默认：*
		 */
		private List<String> allowedMethods = new ArrayList<String>(){{ add("*"); }};
		/**
		 * 允许的headers，默认：*
		 */
		private List<String> allowedHeaders = new ArrayList<String>(){{ add("*"); }};
		/**
		 * 暴露的头
		 */
		private List<String> exposedHeaders = new ArrayList<>();
		/**
		 * 允许凭据，默认：true
		 */
		private Boolean allowCredentials = Boolean.TRUE;
		/**
		 * 时长，默认：30 分钟
		 */
		private long maxAge = 1800L;
	}
}
