/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.version;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import net.dreamlu.boot.annotation.ApiVersion;
import net.dreamlu.tool.util.StringUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class DreamRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo mappinginfo = super.getMappingForMethod(method, handlerType);
        if (mappinginfo != null) {
            RequestMappingInfo apiVersionMappingInfo = this.getApiVersionMappingInfo(method, handlerType);
            return apiVersionMappingInfo == null ? mappinginfo : apiVersionMappingInfo.combine(mappinginfo);
        }
        return mappinginfo;
    }

    private RequestMappingInfo getApiVersionMappingInfo(Method method, Class<?> handlerType) {
        ApiVersion apiVersion = (ApiVersion)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ApiVersion.class);
        if (apiVersion == null || StringUtils.isBlank((CharSequence)apiVersion.value())) {
            apiVersion = (ApiVersion)AnnotatedElementUtils.findMergedAnnotation(handlerType, ApiVersion.class);
        }
        return apiVersion == null || StringUtils.isBlank((CharSequence)apiVersion.value()) ? null : RequestMappingInfo.paths((String[])new String[]{apiVersion.value()}).build();
    }
}

