/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.result;

import net.dreamlu.boot.result.IResultCode;
import net.dreamlu.boot.result.Result;
import net.dreamlu.boot.result.SystemCode;

public class Results {
    public static <T> Result<T> status(boolean status) {
        return status ? Results.success() : Results.failure();
    }

    public static <T> Result<T> success(T data) {
        return Results.result(SystemCode.SUCCESS, data);
    }

    public static <T> Result<T> success() {
        return SystemCode.SUCCESS.toResult();
    }

    public static <T> Result<T> failure(String msg) {
        return Results.result(SystemCode.FAILURE.getCode(), msg, null);
    }

    public static <T> Result<T> failure(IResultCode resultCode) {
        return resultCode.toResult();
    }

    public static <T> Result<T> failure() {
        return SystemCode.FAILURE.toResult();
    }

    private static <T> Result<T> result(IResultCode resultCode, T data) {
        return Results.result(resultCode.getCode(), resultCode.getDesc(), data);
    }

    private static <T> Result<T> result(int code, String msg, T data) {
        Result<T> result = new Result<T>();
        result.setCode(code);
        result.setMsg(msg);
        if (data != null) {
            result.setData(data);
        }
        return result;
    }
}

