/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.error;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.dreamlu.boot.properties.DreamProperties;
import org.springframework.boot.autoconfigure.web.BasicErrorController;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public class DreamErrorController
extends BasicErrorController {
    private final DreamProperties properties;
    private final ObjectMapper objectMapper;

    public DreamErrorController(ErrorAttributes errorAttributes, ErrorProperties errorProperties, DreamProperties properties, ObjectMapper objectMapper) {
        super(errorAttributes, errorProperties);
        this.objectMapper = objectMapper;
        this.properties = properties;
    }

    public ModelAndView errorHtml(HttpServletRequest request, HttpServletResponse response) {
        Map body = this.getErrorAttributes(request, this.isIncludeStackTrace(request, MediaType.ALL));
        HttpStatus status = this.getStatus(request);
        response.setStatus(status.value());
        MappingJackson2JsonView view = new MappingJackson2JsonView();
        view.setObjectMapper(this.objectMapper);
        view.setContentType(this.properties.getMvc().getContentType());
        return new ModelAndView((View)view, body);
    }
}

