/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.error;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.dreamlu.boot.error.ExceptionTranslator;
import net.dreamlu.boot.properties.DreamProperties;
import net.dreamlu.boot.result.Result;
import net.dreamlu.boot.result.Results;
import net.dreamlu.tool.util.BeanUtils;
import net.dreamlu.tool.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.DefaultErrorAttributes;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public class DreamErrorAttributes
extends DefaultErrorAttributes {
    private static final Logger log = LoggerFactory.getLogger(DreamErrorAttributes.class);
    private final ExceptionTranslator translator;
    private final DreamProperties properties;

    public DreamErrorAttributes(ExceptionTranslator translator, DreamProperties properties) {
        this.translator = translator;
        this.properties = properties;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        super.resolveException(request, response, handler, ex);
        Result<String> result = this.translator.handle(ex);
        MappingJackson2JsonView view = new MappingJackson2JsonView();
        view.setObjectMapper(JsonUtils.getInstance());
        view.setContentType(this.properties.getMvc().getContentType());
        return new ModelAndView((View)view, BeanUtils.toMap(result));
    }

    public Map<String, Object> getErrorAttributes(RequestAttributes requestAttributes, boolean includeStackTrace) {
        Result<String> result;
        Throwable error = this.getError(requestAttributes);
        if (error == null) {
            Integer status = (Integer)this.getAttribute(requestAttributes, "javax.servlet.error.status_code");
            result = Results.failure(String.valueOf(status));
        } else {
            result = this.translator.handle(error);
        }
        return BeanUtils.toMap(result);
    }

    private <T> T getAttribute(RequestAttributes requestAttributes, String name) {
        return (T)requestAttributes.getAttribute(name, 0);
    }
}

