/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.config;

import java.util.Arrays;
import java.util.Properties;
import net.dreamlu.boot.properties.TransactionalProperties;
import org.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Configuration
@EnableConfigurationProperties(value={TransactionalProperties.class})
@ConditionalOnClass(name={"org.springframework.transaction.PlatformTransactionManager"})
@ConditionalOnProperty(value={"dream.transactional.enabled"}, havingValue="true", matchIfMissing=true)
public class TransactionalConfiguration {
    private static final String TRANSACTION_INTERCEPTOR_NAME = "transactionAdvice";
    private final TransactionalProperties transactionalProperties;
    private final PlatformTransactionManager transactionManager;

    public TransactionalConfiguration(TransactionalProperties transactionalProperties, PlatformTransactionManager transactionManager) {
        this.transactionalProperties = transactionalProperties;
        this.transactionManager = transactionManager;
    }

    @Bean(value={"transactionAdvice"})
    public TransactionInterceptor transactionInterceptor() {
        Properties attributes = new Properties();
        attributes.putAll(this.transactionalProperties.getTxAttributes());
        attributes.setProperty("find*", "PROPAGATION_REQUIRED,readOnly");
        attributes.setProperty("select*", "PROPAGATION_REQUIRED,readOnly");
        attributes.setProperty("insert*", "PROPAGATION_REQUIRED,-Exception");
        attributes.setProperty("update*", "PROPAGATION_REQUIRED,-Exception");
        attributes.setProperty("delete*", "PROPAGATION_REQUIRED,-Exception");
        attributes.setProperty("*", "PROPAGATION_REQUIRED,-Exception");
        return new TransactionInterceptor(this.transactionManager, attributes);
    }

    @Bean
    public AnnotationAwareAspectJAutoProxyCreator transactionProxyCreator() {
        AnnotationAwareAspectJAutoProxyCreator c = new AnnotationAwareAspectJAutoProxyCreator();
        c.setInterceptorNames(new String[]{TRANSACTION_INTERCEPTOR_NAME});
        c.setIncludePatterns(Arrays.asList(this.transactionalProperties.getExecutionPatterns()));
        c.setProxyTargetClass(true);
        c.setOrder(2);
        return c;
    }
}

