/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.config;

import java.util.List;
import net.dreamlu.boot.cache.http.HttpCacheInterceptor;
import net.dreamlu.boot.cache.http.HttpCacheService;
import net.dreamlu.boot.properties.DreamHttpCacheProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.WebMvcProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnProperty(value={"dream.http.cache.enabled"}, havingValue="true")
public class HttpCacheConfiguration
extends WebMvcConfigurerAdapter {
    private final WebMvcProperties webMvcProperties;
    private final DreamHttpCacheProperties properties;
    private final CacheManager cacheManager;

    public HttpCacheConfiguration(DreamHttpCacheProperties properties, WebMvcProperties webMvcProperties, CacheManager cacheManager) {
        this.webMvcProperties = webMvcProperties;
        this.properties = properties;
        this.cacheManager = cacheManager;
    }

    @Bean
    public HttpCacheService httpCacheService() {
        return new HttpCacheService(this.properties, this.cacheManager);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        List<String> excludePatterns = this.properties.getExcludePatterns();
        excludePatterns.add(this.webMvcProperties.getStaticPathPattern());
        HttpCacheInterceptor httpCacheInterceptor = new HttpCacheInterceptor(this.httpCacheService());
        registry.addInterceptor((HandlerInterceptor)httpCacheInterceptor).addPathPatterns(this.properties.getIncludePatterns().toArray(new String[0])).excludePathPatterns(excludePatterns.toArray(new String[0]));
    }
}

