/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.config;

import net.dreamlu.boot.func.FmtFunc;
import net.dreamlu.boot.properties.DreamCrossProperties;
import net.dreamlu.boot.properties.DreamFmtProperties;
import net.dreamlu.boot.properties.DreamHttpCacheProperties;
import net.dreamlu.boot.properties.DreamMessagesProperties;
import net.dreamlu.boot.properties.DreamProperties;
import net.dreamlu.boot.properties.DreamSwaggerProperties;
import net.dreamlu.boot.runer.StartEventListener;
import net.dreamlu.boot.template.DreamTemplate;
import net.dreamlu.tool.util.SpringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.AbstractJsonpResponseBodyAdvice;

@Configuration
@EnableConfigurationProperties(value={DreamProperties.class, DreamFmtProperties.class, DreamCrossProperties.class, DreamSwaggerProperties.class, DreamMessagesProperties.class, DreamHttpCacheProperties.class})
@EnableAspectJAutoProxy(proxyTargetClass=true, exposeProxy=true)
public class DreamBootAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DreamBootAutoConfiguration.class);

    @Bean
    public StartEventListener startEventListener() {
        return new StartEventListener();
    }

    @Bean
    public SpringUtils springUtils() {
        return new SpringUtils();
    }

    @Bean(value={"tpl"})
    public DreamTemplate dreamTemplate(DreamProperties properties) {
        return new DreamTemplate(properties);
    }

    @Bean(value={"fmt"})
    public FmtFunc fmtFunc(DreamFmtProperties properties) {
        return new FmtFunc(properties);
    }

    @Configuration
    @ConditionalOnProperty(value={"dream.cross.cors.enabled"}, havingValue="true")
    public class CorsConfiguration
    extends WebMvcConfigurerAdapter
    implements InitializingBean {
        private final DreamCrossProperties properties;

        public CorsConfiguration(DreamCrossProperties properties) {
            this.properties = properties;
        }

        public void addCorsMappings(CorsRegistry registry) {
            DreamCrossProperties.Cors cors = this.properties.getCors();
            registry.addMapping(cors.getMapping()).allowedOrigins(cors.getAllowedOrigins().toArray(new String[0])).allowedMethods(cors.getAllowedMethods().toArray(new String[0])).allowedHeaders(cors.getAllowedHeaders().toArray(new String[0])).exposedHeaders(cors.getExposedHeaders().toArray(new String[0])).allowCredentials(cors.getAllowCredentials().booleanValue()).maxAge(cors.getMaxAge());
        }

        public void afterPropertiesSet() throws Exception {
            log.info("cors cross is enabled.");
        }
    }

    @ControllerAdvice
    @ConditionalOnProperty(value={"dream.cross.jsonp.enabled"}, havingValue="true")
    public class JsonpResponseAdvice
    extends AbstractJsonpResponseBodyAdvice
    implements InitializingBean {
        public JsonpResponseAdvice() {
            super(new String[]{"callback"});
        }

        protected MediaType getContentType(MediaType contentType, ServerHttpRequest request, ServerHttpResponse response) {
            return new MediaType("application", "javascript", contentType.getCharset());
        }

        public void afterPropertiesSet() throws Exception {
            log.info("jsonp cross is enabled.");
        }
    }
}

