/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.config;

import net.dreamlu.boot.properties.DreamProperties;
import net.dreamlu.tool.captcha.DreamCaptcha;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@AutoConfigureAfter(value={DreamProperties.class})
@ConditionalOnProperty(value={"dream.captcha.enabled"}, havingValue="true")
public class CaptchaConfiguration {
    private final DreamProperties dreamProperties;

    public CaptchaConfiguration(DreamProperties dreamProperties) {
        this.dreamProperties = dreamProperties;
    }

    @Bean
    public DreamCaptcha dreamCaptcha(CacheManager cacheManager) {
        DreamCaptcha captcha = new DreamCaptcha(cacheManager);
        captcha.setCacheName(this.dreamProperties.getCaptcha().getCacheName());
        captcha.setCookieName(this.dreamProperties.getCaptcha().getCookieName());
        return captcha;
    }
}

