/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.cache.http;

import net.dreamlu.boot.properties.DreamHttpCacheProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.util.Assert;

public class HttpCacheService
implements InitializingBean {
    private final DreamHttpCacheProperties properties;
    private final CacheManager cacheManager;
    private Cache cache;

    public HttpCacheService(DreamHttpCacheProperties properties, CacheManager cacheManager) {
        this.properties = properties;
        this.cacheManager = cacheManager;
    }

    public boolean get(String key) {
        Boolean result = (Boolean)this.cache.get((Object)key, Boolean.class);
        return result == null ? false : result;
    }

    public void set(String key) {
        this.cache.put((Object)key, (Object)true);
    }

    public void clear() {
        this.cache.clear();
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cacheManager, (String)"cacheManager must not be null!");
        String cacheName = this.properties.getCacheName();
        this.cache = this.cacheManager.getCache(cacheName);
        Assert.notNull((Object)this.cache, (String)("HttpCacheCache cacheName: " + cacheName + " is not config."));
    }
}

