package net.dreamlu.boot.runer;

import lombok.extern.slf4j.Slf4j;
import net.dreamlu.tool.util.StringUtils;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;

/**
 * 项目启动事件通知
 *
 * @author L.cm
 */
@Slf4j
public class StartEventListener {

	@Async
	@Order
	@EventListener(EmbeddedServletContainerInitializedEvent.class)
	public void afterStart(EmbeddedServletContainerInitializedEvent event) {
		String[] profiles = event.getApplicationContext().getEnvironment().getActiveProfiles();
		String profile = StringUtils.join(profiles);
		log.info("----项目启动完成，当前使用的环境变量:[{}]----", profile);
	}
}
