package net.dreamlu.boot.result;

import lombok.Getter;

/**
 * 系统内置code
 *
 * @author L.cm
 */
public enum SystemCode implements IResultCode {
	FAILURE(0, "操作失败"),
	SUCCESS(1, "操作成功");

	/**
	 * code编码
	 */
	@Getter
	final int code;
	/**
	 * 中文信息描述
	 */
	@Getter
	final String desc;

	/**
	 * @param code  业务code编码
	 * @param desc  中文信息描述
	 */
	SystemCode(final int code, final String desc) {
		this.code = code;
		this.desc = desc;
	}
}
