package net.dreamlu.boot.result;

/**
 * 结果集返回工具
 *
 * @author L.cm
 */
public class Results {
	/**
	 * 数据库操作结果
	 * @param status 数据库操作结果
	 * @param <T> 泛型标记
	 * @return Result
	 */
	public static <T> Result<T> status(boolean status) {
		return status ? Results.success() : Results.failure();
	}

	/**
	 * 成功-携带数据
	 * @param data 数据
	 * @param <T> 泛型标记
	 * @return Result
	 */
	public static <T> Result<T> success(T data) {
		return result(SystemCode.SUCCESS, data);
	}

	/**
	 * 返回成功
	 * @param <T> 泛型标记
	 * @return Result
	 */
	public static <T> Result<T> success() {
		return SystemCode.SUCCESS.toResult();
	}

	/**
	 * 返回失败信息
	 * @param msg 失败信息
	 * @param <T> 泛型标记
	 * @return Result
	 */
	public static <T> Result<T> failure(String msg) {
		return result(SystemCode.FAILURE.getCode(), msg,null);
	}

	/**
	 * 返回失败信息
	 * @param resultCode 失败信息
	 * @param <T> 泛型标记
	 * @return Result
	 */
	public static <T> Result<T> failure(IResultCode resultCode) {
		return resultCode.toResult();
	}

	/**
	 * 返回失败信息
	 * @param <T> 泛型标记
	 * @return Result
	 */
	public static <T> Result<T> failure() {
		return SystemCode.FAILURE.toResult();
	}

	private static <T> Result<T> result(IResultCode resultCode, T data) {
		return result(resultCode.getCode(), resultCode.getDesc(), data);
	}

	private static <T> Result<T> result(int code, String msg, T data) {
		Result<T> result = new Result<>();
		result.setCode(code);
		result.setMsg(msg);
		if (data != null) {
			result.setData(data);
		}
		return result;
	}
}
