package net.dreamlu.boot.result;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 结果集封装
 *
 * @param <T> 泛型标记
 * @author L.cm
 */
@Data
@ApiModel(description = "Result模型")
public class Result<T> implements Serializable {
	private static final long serialVersionUID = -1160662278280275915L;

	@ApiModelProperty(value = "code码[0:失败,1:成功]", required = true)
	private int code;
	@ApiModelProperty("数据")
	private T data;
	@ApiModelProperty("消息")
	private String msg;
}
