package net.dreamlu.boot.properties;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.LinkedHashMap;
import java.util.Map;

@Getter
@Setter
@ConfigurationProperties("dream.transactional")
public class TransactionalProperties {

	/**
	 * 拦截的正则表达式，默认：execution(public net.dreamlu..service..*.*(..))
	 */
	private String executionPatterns = "execution(public net.dreamlu..service..*.*(..))";
	/**
	 * txAttributes
	 */
	private Map<String, String> txAttributes = new LinkedHashMap<>();

}
