package net.dreamlu.boot.properties;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

@Getter
@Setter
@ConfigurationProperties("dream.swagger")
public class DreamSwaggerProperties {
	/**
	 * 标题
	 */
	private String title;
	/**
	 * 详情
	 */
	private String description;
	/**
	 * 版本号
	 */
	private String version;
	/**
	 * 组织名，默认：Dream
	 */
	private String contactUser = "如梦技术";
	/**
	 * 组织url，默认：https://www.dreamlu.com
	 */
	private String contactUrl = "https://www.dreamlu.net/";
	/**
	 * 组织邮箱，默认：596392912@qq.com
	 */
	private String contactEmail = "596392912@qq.com";

	/**
	 * 全局统一鉴权配置
	 **/
	private Authorization authorization = new Authorization();

	/**
	 * securitySchemes 支持方式之一 ApiKey
	 */
	@Getter
	@Setter
	public static class Authorization {
		/**
		 * 开启Authorization，默认：false
		 */
		private Boolean enabled = false;
		/**
		 * 鉴权策略ID，对应 SecurityReferences ID，默认：Authorization
		 */
		private String name = "Authorization";
		/**
		 * 鉴权传递的Header参数，默认：TOKEN
		 */
		private String keyName = "TOKEN";
		/**
		 * 需要开启鉴权URL的正则，默认：^.*$
		 */
		private String authRegex = "^.*$";
	}
}
