package net.dreamlu.boot.properties;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.nio.charset.Charset;

/**
 * messages配置
 *
 * @author L.cm
 */
@ConfigurationProperties("dream.messages")
public class DreamMessagesProperties {

	/**
	 * Message bundles encoding.
	 */
	@Getter
	@Setter
	private Charset encoding = Charset.forName("UTF-8");

	/**
	 * Files cache seconds. When set to -1 cached forever.
	 */
	@Getter
	@Setter
	private int cacheSeconds = -1;

	/**
	 * fall back to the system Locale if no files
	 */
	@Getter
	@Setter
	private boolean fallbackToSystemLocale = true;

	/**
	 * MessageFormat rules
	 */
	@Getter
	@Setter
	private boolean alwaysUseMessageFormat = false;

	@Getter
	private final Validator validator = new Validator();

	/**
	 * Bean Validator messages配置
	 */
	@Getter
	@Setter
	public static class Validator {
		/**
		 * Bean Validator basename，默认：ValidationMessages，使用hibernate-validator自带
		 */
		private String basename = "ValidationMessages";
	}

	@Getter
	private final Exception exception = new Exception();

	/**
	 * Exception messages配置
	 */
	@Getter
	@Setter
	public static class Exception {
		/**
		 * Exception basename，默认：ValidationMessages，使用hibernate-validator自带
		 */
		private String basename = "messages/errorMessages";
	}

}
