package net.dreamlu.boot.properties;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.ArrayList;
import java.util.List;

@ConfigurationProperties("dream.http.cache")
public class DreamHttpCacheProperties {
	/**
	 * Http-cache 的 spring cache名，默认：dreamHttpCache
	 */
	@Getter
	@Setter
	private String cacheName = DreamDefaults.HttpCache.chacheName;
	/**
	 * 默认拦截/**
	 */
	@Getter
	private final List<String> includePatterns = new ArrayList<String>(){{ add("/**"); }};
	/**
	 * 默认排除静态文件目录
	 */
	@Getter
	private final List<String> excludePatterns = new ArrayList<>();
}
