package net.dreamlu.boot.properties;

import lombok.Getter;
import net.dreamlu.tool.util.PathUtils;
import org.springframework.http.MediaType;

import java.util.ArrayList;
import java.util.List;

public interface DreamDefaults {

	interface Mvc {
		String contentType = MediaType.APPLICATION_JSON_UTF8_VALUE;
	}

	interface Login {
		int retryLimit = 5;
		String retryLimitCacheName = "retryLimitCache";
	}

	interface Async {
		int corePoolSize = 2;
		int maxPoolSize = 50;
		int queueCapacity = 10000;
		int keepAliveSeconds = 300;
	}

	interface Captcha {
		String cookieName = "dream-captcha";
		String chacheName = "dreamCaptchaCache";
	}

	interface Locale {
		String cookieName = "DREAM-LANG";
		String paramName = "language";
		java.util.Locale defaultLocale = java.util.Locale.SIMPLIFIED_CHINESE;
	}

	interface Upload {
		String savePath = PathUtils.getJarPath();
	}

	interface Tpl {
		String open = "{{";
		String close = "}}";
		String prefix = "classpath:templates/tpl/";
		boolean cache = true;
	}

	interface HttpCache {
		String chacheName = "dreamHttpCache";
	}
}
