package net.dreamlu.boot.error;

import com.fasterxml.jackson.databind.ObjectMapper;
import net.dreamlu.boot.properties.DreamProperties;
import org.springframework.boot.autoconfigure.web.BasicErrorController;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * 更改html请求异常为ajax
 *
 * @author L.cm
 */
public class DreamErrorController extends BasicErrorController {

	private final DreamProperties properties;
	private final ObjectMapper objectMapper;

	public DreamErrorController(
		ErrorAttributes errorAttributes,
		ErrorProperties errorProperties,
		DreamProperties properties,
		ObjectMapper objectMapper) {
		super(errorAttributes, errorProperties);
		this.objectMapper = objectMapper;
		this.properties = properties;
	}

	@Override
	public ModelAndView errorHtml(HttpServletRequest request, HttpServletResponse response) {
		Map<String, Object> body = getErrorAttributes(request, isIncludeStackTrace(request, MediaType.ALL));
		HttpStatus status = getStatus(request);
		response.setStatus(status.value());
		MappingJackson2JsonView view = new MappingJackson2JsonView();
		view.setObjectMapper(objectMapper);
		view.setContentType(properties.getMvc().getContentType());
		return new ModelAndView(view, body);
	}
}
