package net.dreamlu.boot.config;

import net.dreamlu.boot.properties.DreamMessagesProperties;
import org.hibernate.validator.HibernateValidator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@AutoConfigureAfter(DreamMessagesProperties.class)
public class ValidatorConfiguration extends WebMvcConfigurerAdapter {

	private final DreamMessagesProperties properties;

	public ValidatorConfiguration(DreamMessagesProperties properties) {
		this.properties = properties;
	}

	/**
	 * 配置 HibernateValidator 国际化
	 * @return Validator
	 */
	@Override
	public Validator getValidator() {
		LocalValidatorFactoryBean validator = new LocalValidatorFactoryBean();
		validator.setProviderClass(HibernateValidator.class);
		ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
		messageSource.setBasename(properties.getValidator().getBasename());
		messageSource.setCacheSeconds(properties.getCacheSeconds());
		messageSource.setDefaultEncoding(properties.getEncoding().name());
		messageSource.setAlwaysUseMessageFormat(properties.isAlwaysUseMessageFormat());
		messageSource.setFallbackToSystemLocale(properties.isFallbackToSystemLocale());
		validator.setValidationMessageSource(messageSource);
		return validator;
	}
}
