package net.dreamlu.boot.config;

import net.dreamlu.boot.properties.DreamProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.*;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import java.nio.charset.StandardCharsets;
import java.util.List;

@Configuration
public class UploadResourceConfigurtion extends WebMvcConfigurerAdapter {

	private final DreamProperties dreamProperties;

	public UploadResourceConfigurtion(DreamProperties dreamProperties) {
		this.dreamProperties = dreamProperties;
	}

	@Override
	public void addResourceHandlers(ResourceHandlerRegistry registry) {
		String path = dreamProperties.getUpload().getSavePath();
		registry.addResourceHandler("/upload/**")
			.addResourceLocations("file:" + path + "/upload/");
	}

	/**
	 * 消息转换，内置断点续传，下载和字符串
	 *
	 * @param converters 转换器
	 */
	@Override
	public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
		super.configureMessageConverters(converters);
		converters.add(new StringHttpMessageConverter(StandardCharsets.UTF_8));
		converters.add(new ByteArrayHttpMessageConverter());
		converters.add(new ResourceHttpMessageConverter());
		converters.add(new ResourceRegionHttpMessageConverter());
		converters.add(new ResourceRegionHttpMessageConverter());
	}
}
