package net.dreamlu.boot.config;

import net.dreamlu.boot.properties.DreamProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;

import java.util.Locale;

/**
 * 国际化配置
 *
 * @author L.cm
 */
@Configuration
public class LocaleConfiguration extends WebMvcConfigurerAdapter {

	private final DreamProperties dreamProperties;

	public LocaleConfiguration(DreamProperties dreamProperties) {
		this.dreamProperties = dreamProperties;
	}

	@Bean
	@ConditionalOnMissingBean(value = LocaleResolver.class, search = SearchStrategy.CURRENT)
	public LocaleResolver localeResolver() {
		CookieLocaleResolver localeResolver = new CookieLocaleResolver();
		localeResolver.setDefaultLocale(dreamProperties.getLocale().getDefaultLocale());
		localeResolver.setCookieName(dreamProperties.getLocale().getCookieName());
		return localeResolver;
	}

	@Override
	public void addInterceptors(InterceptorRegistry registry) {
		LocaleChangeInterceptor localeChangeInterceptor = new LocaleChangeInterceptor();
		localeChangeInterceptor.setParamName(dreamProperties.getLocale().getParamName());
		registry.addInterceptor(localeChangeInterceptor);
	}
}
