package net.dreamlu.boot.config;

import net.dreamlu.boot.properties.DreamProperties;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.aop.interceptor.SimpleAsyncUncaughtExceptionHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * 异步处理
 *
 * @author L.cm
 */
@Configuration
@EnableAsync
@EnableScheduling
public class ExecutorConfiguration extends AsyncConfigurerSupport {

	private final DreamProperties dreamProperties;

	public ExecutorConfiguration(DreamProperties dreamProperties) {
		this.dreamProperties = dreamProperties;
	}

	@Override
	@Bean(name = "taskExecutor")
	public Executor getAsyncExecutor() {
		ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
		executor.setCorePoolSize(dreamProperties.getAsync().getCorePoolSize());
		executor.setMaxPoolSize(dreamProperties.getAsync().getMaxPoolSize());
		executor.setQueueCapacity(dreamProperties.getAsync().getQueueCapacity());
		executor.setKeepAliveSeconds(dreamProperties.getAsync().getKeepAliveSeconds());
		executor.setThreadNamePrefix("async-executor-");
		executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
		return executor;
	}

	@Override
	public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
		return new SimpleAsyncUncaughtExceptionHandler();
	}

}
