package net.dreamlu.boot.cache.http;

import net.dreamlu.boot.properties.DreamHttpCacheProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.util.Assert;

public class HttpCacheService implements InitializingBean {
	private final DreamHttpCacheProperties properties;
	private final CacheManager cacheManager;
	private Cache cache;

	public HttpCacheService(DreamHttpCacheProperties properties, CacheManager cacheManager) {
		this.properties = properties;
		this.cacheManager = cacheManager;
	}

	public boolean get(String key) {
		Boolean result = cache.get(key, Boolean.class);
		return result == null ? false : result.booleanValue();
	}

	public void set(String key) {
		cache.put(key, true);
	}

	public void clear() {
		cache.clear();
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		Assert.notNull(cacheManager, "cacheManager must not be null!");
		String cacheName = properties.getCacheName();
		this.cache = cacheManager.getCache(cacheName);
		Assert.notNull(this.cache, "HttpCacheCache cacheName: " + cacheName + " is not config.");
	}
}
