/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.support;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import net.dreamlu.tool.util.Charsets;
import net.dreamlu.tool.util.URLUtils;
import net.dreamlu.tool.util.WebUtils;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourceRegion;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public abstract class BaseController {
    protected String redirect(String url) {
        return "redirect:" + url;
    }

    protected ResponseEntity<ResourceRegion> download(File file) throws IOException {
        String fileName = file.getName();
        return this.download(file, fileName);
    }

    protected ResponseEntity<ResourceRegion> download(File file, String fileName) throws IOException {
        FileSystemResource resource = new FileSystemResource(file);
        return this.download((Resource)resource, fileName);
    }

    protected ResponseEntity<ResourceRegion> download(Resource resource, String fileName) throws IOException {
        HttpStatus status;
        HttpServletRequest request = WebUtils.getRequest();
        String header = request.getHeader("User-Agent");
        String string = header = header == null ? "" : header.toUpperCase();
        if (header.contains("MSIE") || header.contains("TRIDENT") || header.contains("EDGE")) {
            fileName = URLUtils.encodeURL((String)fileName, (Charset)Charsets.UTF_8);
            status = HttpStatus.OK;
        } else {
            fileName = new String(fileName.getBytes(Charsets.UTF_8), Charsets.ISO_8859_1);
            status = HttpStatus.CREATED;
        }
        long position = 0L;
        long count = resource.contentLength();
        String range = request.getHeader("Range");
        if (null != range) {
            status = HttpStatus.PARTIAL_CONTENT;
            String[] rangeRange = range.replace("bytes=", "").split("-");
            position = Long.parseLong(rangeRange[0]);
            if (rangeRange.length > 1) {
                long end = Long.parseLong(rangeRange[1]);
                count = end - position + 1L;
            }
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        headers.setContentDispositionFormData("attachment", fileName);
        return new ResponseEntity((Object)new ResourceRegion(resource, position, count), (MultiValueMap)headers, status);
    }
}

