/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.error;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.Servlet;
import net.dreamlu.boot.error.DreamErrorAttributes;
import net.dreamlu.boot.error.DreamErrorController;
import net.dreamlu.boot.error.ExceptionTranslator;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.context.MessageSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.web.BasicErrorController;
import org.springframework.boot.autoconfigure.web.DefaultErrorAttributes;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.boot.autoconfigure.web.ErrorController;
import org.springframework.boot.autoconfigure.web.ErrorMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
@AutoConfigureBefore(value={ErrorMvcAutoConfiguration.class})
public class DreamErrorMvcAutoConfiguration {
    private final ServerProperties serverProperties;
    private final ObjectMapper objectMapper;
    private final MessageSourceAutoConfiguration messageSourceAutoConfiguration;

    public DreamErrorMvcAutoConfiguration(ServerProperties serverProperties, ObjectMapper objectMapper, MessageSourceAutoConfiguration messageSourceAutoConfiguration) {
        this.serverProperties = serverProperties;
        this.objectMapper = objectMapper;
        this.messageSourceAutoConfiguration = messageSourceAutoConfiguration;
    }

    @Bean
    @ConditionalOnMissingBean(value={ExceptionTranslator.class}, search=SearchStrategy.CURRENT)
    public ExceptionTranslator exceptionTranslator() {
        MessageSource messageSource = this.getMessageSource(this.messageSourceAutoConfiguration);
        return new ExceptionTranslator(messageSource);
    }

    @Bean
    @ConditionalOnMissingBean(value={ErrorAttributes.class}, search=SearchStrategy.CURRENT)
    public DefaultErrorAttributes errorAttributes(ExceptionTranslator exceptionTranslator) {
        return new DreamErrorAttributes(exceptionTranslator);
    }

    @Bean
    @ConditionalOnMissingBean(value={ErrorController.class}, search=SearchStrategy.CURRENT)
    public BasicErrorController basicErrorController(ErrorAttributes errorAttributes) {
        return new DreamErrorController(errorAttributes, this.serverProperties.getError(), this.objectMapper);
    }

    public MessageSource getMessageSource(MessageSourceAutoConfiguration messageSourceAutoConfiguration) {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasename("classpath:messages/errorMessages");
        messageSource.setCacheSeconds(messageSourceAutoConfiguration.getCacheSeconds());
        messageSource.setDefaultEncoding(messageSourceAutoConfiguration.getEncoding().name());
        messageSource.setAlwaysUseMessageFormat(messageSourceAutoConfiguration.isAlwaysUseMessageFormat());
        messageSource.setFallbackToSystemLocale(messageSourceAutoConfiguration.isFallbackToSystemLocale());
        return messageSource;
    }
}

