/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.error;

import java.util.Map;
import net.dreamlu.boot.error.ExceptionTranslator;
import net.dreamlu.boot.result.Result;
import net.dreamlu.boot.result.Results;
import net.dreamlu.tool.util.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.DefaultErrorAttributes;
import org.springframework.web.context.request.RequestAttributes;

public class DreamErrorAttributes
extends DefaultErrorAttributes {
    private static final Logger log = LoggerFactory.getLogger(DreamErrorAttributes.class);
    private final ExceptionTranslator exceptionTranslator;

    public DreamErrorAttributes(ExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }

    public Map<String, Object> getErrorAttributes(RequestAttributes requestAttributes, boolean includeStackTrace) {
        Result result;
        Throwable error = this.getError(requestAttributes);
        if (error == null) {
            Integer status = (Integer)this.getAttribute(requestAttributes, "javax.servlet.error.status_code");
            result = Results.failure(String.valueOf(status));
        } else {
            String message = this.exceptionTranslator.handle(error);
            result = Results.failure(message);
        }
        return BeanUtils.toMap(result);
    }

    private <T> T getAttribute(RequestAttributes requestAttributes, String name) {
        return (T)requestAttributes.getAttribute(name, 0);
    }
}

