/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.config;

import io.swagger.annotations.Api;
import net.dreamlu.boot.properties.DreamSwaggerProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.configuration.Swagger2DocumentationConfiguration;

@Configuration
@ConditionalOnClass(value={Swagger2DocumentationConfiguration.class})
@Import(value={Swagger2DocumentationConfiguration.class, BeanValidatorPluginsConfiguration.class})
@AutoConfigureAfter(value={DreamSwaggerProperties.class})
public class SwaggerConfiguration {
    private final DreamSwaggerProperties properties;

    public SwaggerConfiguration(DreamSwaggerProperties properties) {
        this.properties = properties;
    }

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).groupName(this.properties.getName()).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.withClassAnnotation(Api.class)).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.properties.getTitle()).description(this.properties.getDescription()).version(this.properties.getVersion()).contact(new Contact(this.properties.getContactUser(), this.properties.getContactUrl(), this.properties.getContactEmail())).build();
    }
}

