/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.cache.http;

import java.lang.reflect.Method;
import java.time.Clock;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.dreamlu.boot.cache.http.HttpCacheAble;
import net.dreamlu.tool.util.ClassUtils;
import net.dreamlu.tool.util.StringUtils;
import net.dreamlu.tool.util.WebUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.http.HttpMethod;

@Aspect
@Order
public class HttpCacheAspect {
    private static final Logger log = LoggerFactory.getLogger(HttpCacheAspect.class);
    private static final ExpressionParser elParser = new SpelExpressionParser();

    @Around(value="@annotation(cacheAble)")
    public Object aroundWxApi(ProceedingJoinPoint point, HttpCacheAble cacheAble) throws Throwable {
        this.handleHttpCacheAble(point, cacheAble);
        return point.proceed();
    }

    private void handleHttpCacheAble(ProceedingJoinPoint point, HttpCacheAble cacheAble) {
        long lastModified;
        long expires;
        SimpleEvaluationContext context;
        Expression expression;
        boolean useHttpCache;
        HttpServletRequest request = WebUtils.getRequest();
        String method = request.getMethod();
        HttpMethod httpMethod = HttpMethod.resolve((String)method);
        if (httpMethod == null) {
            return;
        }
        List<HttpMethod> allowList = Arrays.asList(HttpMethod.HEAD, HttpMethod.GET);
        if (allowList.indexOf(httpMethod) == -1) {
            return;
        }
        long maxAge = cacheAble.maxAge();
        if (maxAge < 1L) {
            return;
        }
        String condition = cacheAble.condition();
        if (StringUtils.isNotBlank((CharSequence)condition) && !(useHttpCache = ((Boolean)(expression = elParser.parseExpression(condition)).getValue((EvaluationContext)(context = this.getEvaluationContext(point)), Boolean.class)).booleanValue())) {
            return;
        }
        long ims = request.getDateHeader("If-Modified-Since");
        long now = Clock.systemUTC().millis();
        long maxAgeMicros = TimeUnit.SECONDS.toMillis(maxAge);
        HttpServletResponse response = WebUtils.getResponse();
        if (ims + maxAgeMicros > now) {
            response.setStatus(304);
            expires = ims + maxAgeMicros;
            lastModified = ims;
            log.info("{} 304 {}", (Object)method, (Object)request.getRequestURI());
        } else {
            expires = now + maxAgeMicros;
            lastModified = now;
        }
        response.setHeader("Cache-Control", "max-age=" + maxAge);
        response.addDateHeader("Expires", expires);
        response.addDateHeader("Last-Modified", lastModified);
    }

    private SimpleEvaluationContext getEvaluationContext(ProceedingJoinPoint point) {
        SimpleEvaluationContext context = SimpleEvaluationContext.forReadOnlyDataBinding().build();
        MethodSignature ms = (MethodSignature)point.getSignature();
        Method method = ms.getMethod();
        Object[] args = point.getArgs();
        for (int i = 0; i < args.length; ++i) {
            MethodParameter methodParam = ClassUtils.getMethodParameter((Method)method, (int)i);
            Object value = args[i];
            context.setVariable(methodParam.getParameterName(), value);
        }
        return context;
    }
}

