package net.dreamlu.boot.version;

import net.dreamlu.boot.annotation.ApiVersion;
import net.dreamlu.tool.util.StringUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import java.lang.reflect.Method;

/**
 * url版本号处理
 *
 * @author L.cm
 */
public class DreamRequestMappingHandlerMapping extends RequestMappingHandlerMapping {

	@Override
	protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
		RequestMappingInfo mappinginfo = super.getMappingForMethod(method, handlerType);
		if (mappinginfo != null) {
			RequestMappingInfo apiVersionMappingInfo = getApiVersionMappingInfo(method, handlerType);
			return apiVersionMappingInfo == null ? mappinginfo : apiVersionMappingInfo.combine(mappinginfo);
		}
		return mappinginfo;
	}

	private RequestMappingInfo getApiVersionMappingInfo(Method method, Class<?> handlerType) {
		// 优先获取方法上的版本
		ApiVersion apiVersion = AnnotatedElementUtils.findMergedAnnotation(method, ApiVersion.class);
		// 再次尝试类上的版本
		if (apiVersion == null || StringUtils.isBlank(apiVersion.value())) {
			apiVersion = AnnotatedElementUtils.findMergedAnnotation(handlerType, ApiVersion.class);
		}
		return apiVersion == null || StringUtils.isBlank(apiVersion.value()) ? null : RequestMappingInfo
			.paths(apiVersion.value())
			.build();
	}
}
